package lostcoder.ic2.nuclearpan;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

import org.lwjgl.opengl.GL11;

public class GuiNuclearPan extends GuiContainer
{
    TileEntityNuclearPan tile;

    public GuiNuclearPan(EntityPlayer player, TileEntityNuclearPan tile)
    {
        super(new ContainerNuclearPan(player, tile));
        this.tile = tile;
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2)
    {
        //fontRenderer.drawString(StatCollector.translateToLocal(entity.getInvName()), 8, 6, 4210752);
        fontRenderer.drawString("Nuclear Pan", 8, 6, 4210752);
        fontRenderer.drawString(String.format("Heat: %d", tile.heat), 48, 54, 4210752);
        fontRenderer.drawString(StatCollector.translateToLocal("container.inventory"), 8, ySize - 96 + 2, 4210752);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3)
    {
        int k = mc.renderEngine.getTexture("/lostcoder/ic2/nuclearpan/gui.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        mc.renderEngine.bindTexture(k);
        drawTexturedModalRect(guiLeft, guiTop, 0, 0, xSize, ySize);

        float scaled = (tile.progress >= 500) ? 1.0F : tile.progress / 500.0F;
        drawTexturedModalRect(
                guiLeft + 71, // x
                guiTop + 29, // y
                176, // u
                0, // v
                (int) (scaled * 24), // width
                17); // height
    }

}
