package lostcoder.ic2.nuclearpan;

import ic2.api.Items;

import java.util.Random;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockNuclearPan extends BlockContainer
{
    private Random rand = new Random();

    public BlockNuclearPan(int id, Material material)
    {
        super(id, material);
        setBlockBounds(0.0F, 0.0F, 0.0F, 1.0F, 0.25F, 1.0F);
    }

    @Override
    public String getTextureFile()
    {
        return CommonProxy.BLOCKS_PNG;
    }

    @Override
    public int getBlockTextureFromSide(int side)
    {
        /* Sides:
           0 - down
           1 - up
           2 - side */
        return 16 + (side >= 2 ? 2 : side);
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9)
    {
        super.onBlockActivated(world, x, y, z, player, par6, par7, par8, par9);
        if (player.isSneaking()) return false; // Drop through if player is sneaking
        if (!world.isRemote) player.openGui(NuclearPan.instance, 0, world, x, y, z);
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World world)
    {
        return new TileEntityNuclearPan();
    }

    @Override
    public boolean canBeReplacedByLeaves(World world, int x, int y, int z)
    {
        return false;
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, int par5, int par6)
    {
        TileEntityNuclearPan tile = (TileEntityNuclearPan) world.getBlockTileEntity(x, y, z);

        if (tile != null)
        {
            for (int i = 0; i < tile.getSizeInventory(); i++)
            {
                ItemStack stack = tile.getStackInSlot(i);

                if (stack != null)
                {
                    float dx = rand.nextFloat() * 0.8F + 0.1F;
                    float dy = rand.nextFloat() * 0.8F + 0.1F;
                    float dz = rand.nextFloat() * 0.8F + 0.1F;

                    while (stack.stackSize > 0)
                    {
                        int count = rand.nextInt(21) + 10;

                        if (count > stack.stackSize) count = stack.stackSize;

                        stack.stackSize -= count;
                        EntityItem entity = new EntityItem(world, x + dx, y + dy, z + dz, new ItemStack(stack.itemID, count, stack.getItemDamage()));

                        if (stack.hasTagCompound())
                        {
                            entity.getEntityItem().setTagCompound((NBTTagCompound)stack.getTagCompound().copy());
                        }

                        float var15 = 0.05F;
                        entity.motionX = (float)rand.nextGaussian() * var15;
                        entity.motionY = (float)rand.nextGaussian() * var15 + 0.2F;
                        entity.motionZ = (float)rand.nextGaussian() * var15;
                        world.spawnEntityInWorld(entity);
                    }
                }
            }
        }

        super.breakBlock(world, x, y, z, par5, par6);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z)
    {
        if (super.canPlaceBlockAt(world, x, y, z))
        {
            return canBlockStay(world, x, y, z);
        }
        else
        {
            return false;
        }
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z)
    {
        if (y == 0) return false;

        // Get block id below current position
        int id = world.getBlockId(x, y-1, z);

        // Check whether block is reactor or reactor chamber
        ItemStack nuclearReactor = Items.getItem("nuclearReactor");
        ItemStack reactorChamber = Items.getItem("reactorChamber");

        return (id == nuclearReactor.itemID || id == reactorChamber.itemID);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int neighborBlockID)
    {
        if (!canBlockStay(world, x, y, z))
        {
            dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public boolean isOpaqueCube()
    {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock()
    {
        return false;
    }
}
