package lostcoder.ic2.nuclearpan;

import ic2.api.Ic2Recipes;
import ic2.api.Items;

import java.util.LinkedList;

import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;

@Mod(modid="NuclearPan", name="NuclearPan", version="1.0", dependencies="required-after:IC2")
@NetworkMod(clientSideRequired=true, serverSideRequired=true)
public class NuclearPan
{
    // The instance of mod that Forge uses.
    @Instance("NuclearPan")
    public static NuclearPan instance;

    // Says where the client and server 'proxy' code is loaded.
    @SidedProxy(clientSide="lostcoder.ic2.nuclearpan.ClientProxy", serverSide="lostcoder.ic2.nuclearpan.CommonProxy")
    public static CommonProxy proxy;

    public int blockID  = 778;
    public int ashPileID = 29900;
    public int minHeat = 40;
    public int maxHeat = 240;
    public int heatPerItem = 1000;

    public Item ashPile;

    public static final LinkedList<ItemStack> whiteList = new LinkedList<ItemStack>();

    @PreInit
    public void preInit(FMLPreInitializationEvent event)
    {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try
        {
            config.load();
            blockID = config.get("NuclearPan", "NuclearPanBlockID", blockID).getInt(blockID);
            ashPileID = config.get("NuclearPan", "AshPileItemID", ashPileID).getInt(ashPileID);

            Property prop = config.get("NuclearPan", "MinHeat", minHeat);
            prop.comment = "Minimum heat treshold to start cooking.";
            minHeat = prop.getInt(minHeat);

            prop = config.get("NuclearPan", "MaxHeat", maxHeat);
            prop.comment = "Minimum heat treshold to start cooking... ash piles.";
            maxHeat = prop.getInt(maxHeat);

            prop = config.get("NuclearPan", "HeatPerItem", heatPerItem);
            prop.comment = "Amount of heat required to cook one item.";
            heatPerItem = prop.getInt(heatPerItem);
        }
        finally
        {
            config.save();
        }
    }

    @Init
    public void load(FMLInitializationEvent event)
    {
        ashPile = new Item(ashPileID - 256);
        ashPile.setItemName("ashPile");
        ashPile.setTextureFile(CommonProxy.ITEMS_PNG);
        ashPile.setIconIndex(0);
        ashPile.setNoRepair();
        LanguageRegistry.addName(ashPile, "Ash Pile");

        BlockNuclearPan nuclearPan = new BlockNuclearPan(blockID, new Material(MapColor.ironColor));
        nuclearPan.setStepSound(Block.soundMetalFootstep);
        nuclearPan.setHardness(2.0F);
        nuclearPan.setBlockName("nuclearPan");
        GameRegistry.registerBlock(nuclearPan, "nuclearPan");
        GameRegistry.registerTileEntity(TileEntityNuclearPan.class, "TileEntityNuclearPan");
        LanguageRegistry.addName(nuclearPan, "Nuclear Pan");

        if (event.getSide() == Side.CLIENT)
        {
            ashPile.setCreativeTab(CreativeTabs.tabFood);
            nuclearPan.setCreativeTab(Items.getItem("nuclearReactor").getItem().getCreativeTab());
        }

        Ic2Recipes.addCraftingRecipe(
                new ItemStack(nuclearPan),
                new Object[] {
                    "   ", "RAR", "RCR",
                    'R', Items.getItem("refinedIronIngot"),
                    'A', Items.getItem("advancedAlloy"),
                    'C', Items.getItem("denseCopperPlate")
                });

        NetworkRegistry.instance().registerGuiHandler(instance, new GuiHandler());

        addToWhiteList(Items.getItem("mugCoffee"));
        addToWhiteList(new ItemStack(Block.cactus));
    }

    /**
     * Kind of API.
     */
    public static boolean addToWhiteList(ItemStack stack)
    {
        return whiteList.add(stack.copy());
    }

    public static boolean inWhiteList(ItemStack stack)
    {
        for (ItemStack i : whiteList)
        {
            if (stack.isItemEqual(i)) return true;
        }
        return false;
    }
}
