package lostcoder.ic2.nuclearpan;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemFoodOnAStick extends ItemFood
{
    public ItemFoodOnAStick(int id, int healAmount, float saturationModifier, boolean isWolfsFavoriteMeat)
    {
        super(id, healAmount, saturationModifier, isWolfsFavoriteMeat);
    }

    public ItemFoodOnAStick(int id, int healAmount, boolean isWolfsFavoriteMeat)
    {
        super(id, healAmount, isWolfsFavoriteMeat);
    }

    @Override
    public ItemStack onFoodEaten(ItemStack stack, World world, EntityPlayer player)
    {
        // Eat food
        ItemStack ret = super.onFoodEaten(stack, world, player);

        // Return stick back to player
        ItemStack stick = new ItemStack(Item.stick);
        if (!player.inventory.addItemStackToInventory(stick)) player.dropPlayerItem(stick);

        // Proceed
        return ret;
    }
}
