package lostcoder.ic2.nuclearpan;

import ic2.api.Ic2Recipes;
import ic2.api.Items;

import java.util.LinkedList;

import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;

@Mod(modid="NuclearPan", name="NuclearPan", version="1.01", dependencies="required-after:IC2")
@NetworkMod(clientSideRequired=true, serverSideRequired=true)
public class NuclearPan
{
    // The instance of mod that Forge uses.
    @Instance("NuclearPan")
    public static NuclearPan instance;

    // Says where the client and server 'proxy' code is loaded.
    @SidedProxy(clientSide="lostcoder.ic2.nuclearpan.ClientProxy", serverSide="lostcoder.ic2.nuclearpan.CommonProxy")
    public static CommonProxy proxy;

    // Const
    public static final int NOMINAL_HEAT = 8500;
    public static final int NOMINAL_HPS = NOMINAL_HEAT * 20;

    // Config variables
    public static int meltedSugarID = 29901;
    public static int sugarCandyID = 29902;
    public static int lollipopID = 29903;

    public static int blockID  = 778;
    public static int heatPerItem = NOMINAL_HPS;
    public static int passiveCooling = 5;
    public static int activeCooling = 20;

    public static final LinkedList<ItemStack> whiteList = new LinkedList<ItemStack>();

    @PreInit
    public void preInit(FMLPreInitializationEvent event)
    {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try
        {
            config.load();

            meltedSugarID = config.get("NuclearPan", "MeltedSugarID", meltedSugarID).getInt(meltedSugarID);
            sugarCandyID = config.get("NuclearPan", "SugarCandyID", sugarCandyID).getInt(sugarCandyID);
            lollipopID = config.get("NuclearPan", "LollipopID", lollipopID).getInt(lollipopID);

            blockID = config.get("NuclearPan", "NuclearPanBlockID", blockID).getInt(blockID);

            Property prop;

            prop = config.get("NuclearPan", "HeatPerItem", heatPerItem);
            prop.comment = "Amount of heat required to cook one item.";
            heatPerItem = prop.getInt(heatPerItem);

            prop = config.get("NuclearPan", "PassiveCooling", passiveCooling);
            prop.comment = "Amount of heat to wear from reactor when not cooking (heat per second).";
            passiveCooling = prop.getInt(passiveCooling);

            prop = config.get("NuclearPan", "ActiveCooling", activeCooling);
            prop.comment = "Amount of heat to wear from reactor when cooking (heat per second).";
            activeCooling = prop.getInt(activeCooling);
        }
        finally
        {
            config.save();
        }
    }

    @Init
    public void load(FMLInitializationEvent event)
    {
        // Candies

        // Sugar -> melted sugar; melted sugar -> sugar
        // 2x melted sugar -> sugar candy; sugar candy -> 2x melted sugar; sugar candy -> 2x sugar
        // 3x melted sugar + stick -> lollipop;

        ItemFood meltedSugar = (ItemFood) new ItemFood(meltedSugarID, 2, 0.0F, false).setItemName("meltedSugar").setTextureFile(CommonProxy.ITEMS_PNG).setIconIndex(0);
        ItemFood sugarCandy = (ItemFood) new ItemFood(sugarCandyID, 4, 0.0F, false).setItemName("sugarCandy").setTextureFile(CommonProxy.ITEMS_PNG).setIconIndex(1);
        ItemFoodOnAStick lollipop = (ItemFoodOnAStick) new ItemFoodOnAStick(lollipopID, 8, 0.0F, false).setItemName("lollipop").setTextureFile(CommonProxy.ITEMS_PNG).setIconIndex(2);

        LanguageRegistry.addName(meltedSugar, "Melted Sugar");
        LanguageRegistry.addName(sugarCandy, "Sugar Candy");
        LanguageRegistry.addName(lollipop, "Lollipop");

        ItemStack stackMeltedSugar = new ItemStack(meltedSugar);
        ItemStack stackSugarCandy = new ItemStack(sugarCandy);

        FurnaceRecipes.smelting().addSmelting(Item.sugar.itemID, stackMeltedSugar, 0.1F);
        Ic2Recipes.addMaceratorRecipe(stackMeltedSugar, new ItemStack(Item.sugar));

        Ic2Recipes.addShapelessCraftingRecipe(
                stackSugarCandy,
                new Object[] {
                    stackMeltedSugar,
                    stackMeltedSugar
                });
        FurnaceRecipes.smelting().addSmelting(sugarCandy.itemID, new ItemStack(meltedSugar, 2), 0.1F);
        Ic2Recipes.addMaceratorRecipe(stackSugarCandy, new ItemStack(Item.sugar, 2));

        Ic2Recipes.addShapelessCraftingRecipe(
                new ItemStack(lollipop),
                new Object[] {
                    stackMeltedSugar,
                    stackMeltedSugar,
                    stackMeltedSugar,
                    new ItemStack(Item.stick)
                });

        // Nuclear pan

        BlockNuclearPan nuclearPan = new BlockNuclearPan(blockID, new Material(MapColor.ironColor));
        nuclearPan.setStepSound(Block.soundMetalFootstep);
        nuclearPan.setHardness(2.0F);
        nuclearPan.setBlockName("nuclearPan");
        GameRegistry.registerBlock(nuclearPan, "nuclearPan");
        GameRegistry.registerTileEntity(TileEntityNuclearPan.class, "TileEntityNuclearPan");
        LanguageRegistry.addName(nuclearPan, "Nuclear Pan");

        Ic2Recipes.addCraftingRecipe(
                new ItemStack(nuclearPan),
                new Object[] {
                    "   ", "RAR", "RCR",
                    'R', Items.getItem("refinedIronIngot"),
                    'A', Items.getItem("advancedAlloy"),
                    'C', Items.getItem("denseCopperPlate")
                });

        NetworkRegistry.instance().registerGuiHandler(instance, new GuiHandler());

        addToWhiteList(Items.getItem("mugCoffee"));
        addToWhiteList(new ItemStack(Block.cactus));
        addToWhiteList(new ItemStack(Item.sugar));

        if (event.getSide() == Side.CLIENT)
        {
            meltedSugar.setCreativeTab(CreativeTabs.tabFood);
            sugarCandy.setCreativeTab(CreativeTabs.tabFood);
            lollipop.setCreativeTab(CreativeTabs.tabFood);
            nuclearPan.setCreativeTab(Items.getItem("nuclearReactor").getItem().getCreativeTab());
        }
    }

    /**
     * Kind of API.
     */
    public static boolean addToWhiteList(ItemStack stack)
    {
        return whiteList.add(stack.copy());
    }

    public static boolean inWhiteList(ItemStack stack)
    {
        for (ItemStack i : whiteList)
        {
            if (stack.isItemEqual(i)) return true;
        }
        return false;
    }
}
