package lostcoder.ic2.nuclearpan;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import cpw.mods.fml.common.network.IGuiHandler;

public class GuiHandler implements IGuiHandler
{
    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
    {
        if (!world.blockExists(x, y, z)) return null;
        TileEntity tile = world.getBlockTileEntity(x, y, z);
        if (tile instanceof TileEntityNuclearPan == false) return null;
        if (ID != 0) return null;
        return new ContainerNuclearPan(player, (TileEntityNuclearPan) tile);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
    {
        if (!world.blockExists(x, y, z)) return null;
        TileEntity tile = world.getBlockTileEntity(x, y, z);
        if (tile instanceof TileEntityNuclearPan == false) return null;
        if (ID != 0) return null;
        return new GuiNuclearPan(player, (TileEntityNuclearPan) tile);
    }
}
