package lostcoder.ic2.quantumpack;

import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class IconRenderer implements IItemRenderer
{
    @Override
    public boolean handleRenderType(ItemStack item, ItemRenderType type)
    {
        // Handle only item inventory rendering.
        return (type == ItemRenderType.INVENTORY);
    }

    @Override
    public boolean shouldUseRenderHelper(ItemRenderType type, ItemStack item, ItemRendererHelper helper)
    {
        return false; // Don't need helper
    }

    @Override
    public void renderItem(ItemRenderType type, ItemStack stack, Object... data)
    {
        if (type == ItemRenderType.INVENTORY)
        {
            Tessellator t = Tessellator.instance;

            // Render icon
            int icon = stack.getIconIndex();
            //engine.bindTexture(engine.getTexture(item.getTextureFile())); // already bound
            renderTexturedQuad(t, 0, 0, 0.0D, icon % 16 * 16, icon / 16 * 16, 16, 16);

            // Render bar only for electric items
            if (stack.getItem() instanceof IElectricItem)
            {
                // Get bar value
                float value = (float) ElectricItem.discharge(stack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true) / (float) ((IElectricItem) stack.getItem()).getMaxCharge();

                // Reset texture and render bar
                GL11.glBindTexture(GL11.GL_TEXTURE_2D, 0);
                renderBar(t, value, 2, 13, 0.0D, 13, 2);
            }
        }
    }

    public void renderTexturedQuad(Tessellator t, int x, int y, double z, int u, int v, int w, int h)
    {
        t.startDrawingQuads();
        t.addVertexWithUV(x + 0, y + h, z, (u + 0) / 256.0F, (v + h) / 256.0F);
        t.addVertexWithUV(x + w, y + h, z, (u + w) / 256.0F, (v + h) / 256.0F);
        t.addVertexWithUV(x + w, y + 0, z, (u + w) / 256.0F, (v + 0) / 256.0F);
        t.addVertexWithUV(x + 0, y + 0, z, (u + 0) / 256.0F, (v + 0) / 256.0F);
        t.draw();
    }

    public void renderColoredQuad(Tessellator t, int x, int y, double z, int w, int h, float r, float g, float b, float a)
    {
        t.startDrawingQuads();
        t.setColorRGBA_F(r, g, b, a);
        t.addVertex(x + 0, y + h, z);
        t.addVertex(x + w, y + h, z);
        t.addVertex(x + w, y + 0, z);
        t.addVertex(x + 0, y + 0, z);
        t.draw();
    }

    public void renderBar(Tessellator t, float value, int x, int y, double z, int w, int h)
    {
        // Recalculate a bit
        int filled;
        if (w < 0) w = -w; // abs
        if ((value == 0) || (w == 0))
            filled = 0;
        else
            filled = 1 + (int) (value * (w - 1));
        if (filled < 0) filled = 0; // clamp
        if (filled > w) filled = w;

        // Calculate color depending on fill level
        float alpha = (float) filled / (float) w;
        float r = QuantumPack.barMaxR * alpha + QuantumPack.barMinR * (1 - alpha);
        float g = QuantumPack.barMaxG * alpha + QuantumPack.barMinG * (1 - alpha);
        float b = QuantumPack.barMaxB * alpha + QuantumPack.barMinB * (1 - alpha);

        // Render full-tone bar
        renderColoredQuad(t, x, y, z, filled, h-1, r, g, b, 1.0F);

        // Render bar shadow (bottom)
        renderColoredQuad(t, x, y+h-1, z, w, 1, 0, 0, 0, 1.0F);

        // Render bar background (quarter-tone bar)
        if (filled < w)
        {
            // Calculate dark color
            r /= 4.0F; g /= 4.0F; b /= 4.0F;

            // Render quarter-tone bar (unfilled part)
            renderColoredQuad(t, x+filled, y, z, w-filled-1, h-1, r, g, b, 1.0F);

            // Render shadow (unfilled right piece)
            renderColoredQuad(t, x+w-1, y, z, 1, h-1, 0, 0, 0, 1.0F);
        }
    }
}

