package lostcoder.ic2.quantumpack;

import ic2.api.IElectricItem;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemElectricArmor extends ItemArmor implements ISpecialArmor, IElectricItem
{
    private int maxCharge;
    private int tier;
    private int transferLimit;
    private boolean supportRightClick;

    @SideOnly(Side.CLIENT)
    private EnumRarity rarity;

    public ItemElectricArmor(int id, EnumArmorMaterial material, int renderIndex, int armorType, int maxCharge, int transferLimit, int tier, boolean supportRightClick)
    {
        super(id, material, renderIndex, armorType);
        this.setMaxStackSize(1);
        this.setHasSubtypes(false);
        this.setMaxDamage(0);
        this.setNoRepair();

        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        this.supportRightClick = supportRightClick;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack)
    {
        return rarity;
    }

    @SideOnly(Side.CLIENT)
    public void setRarity(EnumRarity rarity)
    {
        this.rarity = rarity;
    }

    @Override
    public String getTextureFile()
    {
        return CommonProxy.ITEMS_PNG;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack src, World world, EntityPlayer player)
    {
        if (this.supportRightClick) QuantumPack.chargeInventoryItem(src, player);
        return src;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void getSubItems(int id, CreativeTabs tab, List list)
    {
        QuantumPack.getCreativeItems(this, list);
    }

    // ---------------------------- IElectricItem ----------------------------

    @Override
    public int getChargedItemId()
    {
        return this.itemID;
    }

    @Override
    public int getEmptyItemId()
    {
        return this.itemID;
    }

    @Override
    public boolean canProvideEnergy()
    {
        return true;
    }

    @Override
    public int getMaxCharge()
    {
        return this.maxCharge;
    }

    @Override
    public int getTier()
    {
        return this.tier;
    }

    @Override
    public int getTransferLimit()
    {
        return this.transferLimit;
    }

    // ---------------------------- ISpecialArmor ----------------------------

    @Override
    public ArmorProperties getProperties(EntityLiving player, ItemStack armor, DamageSource source, double damage, int slot)
    {
        ArmorProperties p = new ArmorProperties(0, 0, 0);
        p.Slot = slot;
        return p;
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot)
    {
        return 0;
    }

    @Override
    public void damageArmor(EntityLiving entity, ItemStack stack, DamageSource source, int damage, int slot)
    {
        // do nothing
    }
}
