package lostcoder.ic2.quantumpack;

import net.minecraft.item.Item;
import net.minecraftforge.client.MinecraftForgeClient;
import cpw.mods.fml.client.registry.RenderingRegistry;

public class ClientProxy extends CommonProxy
{
    // Instance of a renderer, we need just one of it, so here it is.
    public static final IconRenderer renderer = new IconRenderer();

    public ClientProxy()
    {
        MinecraftForgeClient.preloadTexture(ITEMS_PNG);
    }

    @Override
    public int addNewArmourRendererPrefix(String armor)
    {
        return RenderingRegistry.addNewArmourRendererPrefix(armor);
    }

    @Override
    public void registerIconRenderer(Item item)
    {
        if (item != null) MinecraftForgeClient.registerItemRenderer(item.itemID, renderer);
    }
}
