package lostcoder.ic2.quantumpack;

import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import ic2.api.Ic2Recipes;
import ic2.api.Items;

import java.util.List;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@Mod(modid="QuantumPack", name="QuantumPack", version="1.07", dependencies="required-after:IC2")
@NetworkMod(clientSideRequired=true, serverSideRequired=true)
public class QuantumPack
{
    // The instance of the mod that Forge uses.
    @Instance("QuantumPack")
    public static QuantumPack instance;

    // Says where the client and server 'proxy' code is loaded.
    @SidedProxy(clientSide="lostcoder.ic2.quantumpack.ClientProxy", serverSide="lostcoder.ic2.quantumpack.CommonProxy")
    public static CommonProxy proxy;

    // Config

    private boolean lightAlloyEnabled = true;
    private int     lightAlloyId      = 29957;

    private boolean quantumPackEnabled       = true;
    private int     quantumPackId            = 29956;
    private int     quantumPackMaxCharge     = 1200000;
    private int     quantumPackTransferLimit = 1000;
    private int     quantumPackTier          = 3;
    private boolean quantumPackRightClick    = false;

    private boolean quantumAccumulatorEnabled       = true;
    private int     quantumAccumulatorId            = 29955;
    private int     quantumAccumulatorMaxCharge     = 900000;
    private int     quantumAccumulatorTransferLimit = 1000;
    private int     quantumAccumulatorTier          = 1;
    private boolean quantumAccumulatorRightClick    = true;

    private boolean quantumAccumulatorBigEnabled       = true;
    private int     quantumAccumulatorBigId            = 29954;
    private int     quantumAccumulatorBigMaxCharge     = 5400000;
    private int     quantumAccumulatorBigTransferLimit = 6000;
    private int     quantumAccumulatorBigTier          = 1;
    private boolean quantumAccumulatorBigRightClick    = false;

    private boolean industrialBeltEnabled       = true;
    private int     industrialBeltId            = 29953;
    private int     industrialBeltMaxCharge     = 30000;
    private int     industrialBeltTransferLimit = 100;
    private int     industrialBeltTier          = 1;
    private boolean industrialBeltRightClick    = false;

    public static float barMinR; // 131
    public static float barMinG; // 58
    public static float barMinB; // 255

    public static float barMaxR; // 10
    public static float barMaxG; // 240
    public static float barMaxB; // 255

    // Items

    private Item lightAlloy = null;
    private ItemElectricArmor quantumPack = null;
    private ItemElectricStorage quantumAccumulator = null;
    private ItemElectricStorage quantumAccumulatorBig = null;
    private ItemElectricArmor industrialBelt = null;

    // Helper function - read color from config, clamp it and normalize
    public float getColor(Configuration config, String category, String key, int defaultValue)
    {
        int value = config.get(category, key, defaultValue).getInt(defaultValue);
        if (value >= 255)
            return 1.0F;
        else if (value < 0)
            return 0.0F;
        else
            return value / 255.0F;
    }

    @PreInit
    public void preInit(FMLPreInitializationEvent event)
    {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try
        {
            config.load();

            lightAlloyEnabled = config.get("LightAlloy", "enabled", lightAlloyEnabled).getBoolean(lightAlloyEnabled);
            lightAlloyId      = config.get("LightAlloy", "id", lightAlloyId).getInt(lightAlloyId);

            quantumPackEnabled       = config.get("QuantumPack", "enabled", quantumPackEnabled).getBoolean(quantumPackEnabled);
            quantumPackId            = config.get("QuantumPack", "id", quantumPackId).getInt(quantumPackId);
            quantumPackMaxCharge     = config.get("QuantumPack", "maxCharge", quantumPackMaxCharge).getInt(quantumPackMaxCharge);
            quantumPackTransferLimit = config.get("QuantumPack", "transferLimit", quantumPackTransferLimit).getInt(quantumPackTransferLimit);
            quantumPackTier          = config.get("QuantumPack", "tier", quantumPackTier).getInt(quantumPackTier);
            quantumPackRightClick    = config.get("QuantumPack", "rightClickUse", quantumPackRightClick).getBoolean(quantumPackRightClick);

            quantumAccumulatorEnabled       = config.get("QuantumAccumulator", "enabled", quantumAccumulatorEnabled).getBoolean(quantumAccumulatorEnabled);
            quantumAccumulatorId            = config.get("QuantumAccumulator", "id", quantumAccumulatorId).getInt(quantumAccumulatorId);
            quantumAccumulatorMaxCharge     = config.get("QuantumAccumulator", "maxCharge", quantumAccumulatorMaxCharge).getInt(quantumAccumulatorMaxCharge);
            quantumAccumulatorTransferLimit = config.get("QuantumAccumulator", "transferLimit", quantumAccumulatorTransferLimit).getInt(quantumAccumulatorTransferLimit);
            quantumAccumulatorTier          = config.get("QuantumAccumulator", "tier", quantumAccumulatorTier).getInt(quantumAccumulatorTier);
            quantumAccumulatorRightClick    = config.get("QuantumAccumulator", "rightClickUse", quantumAccumulatorRightClick).getBoolean(quantumAccumulatorRightClick);

            // Migration workaround
            if (config.hasCategory("quantumaccumulatorpack"))
            {
                config.getCategory("bigquantumaccumulator").putAll(config.getCategory("quantumaccumulatorpack").getValues());
                config.categories.remove("quantumaccumulatorpack");
            }

            quantumAccumulatorBigEnabled       = config.get("BigQuantumAccumulator", "enabled", quantumAccumulatorBigEnabled).getBoolean(quantumAccumulatorBigEnabled);
            quantumAccumulatorBigId            = config.get("BigQuantumAccumulator", "id", quantumAccumulatorBigId).getInt(quantumAccumulatorBigId);
            quantumAccumulatorBigMaxCharge     = config.get("BigQuantumAccumulator", "maxCharge", quantumAccumulatorBigMaxCharge).getInt(quantumAccumulatorBigMaxCharge);
            quantumAccumulatorBigTransferLimit = config.get("BigQuantumAccumulator", "transferLimit", quantumAccumulatorBigTransferLimit).getInt(quantumAccumulatorBigTransferLimit);
            quantumAccumulatorBigTier          = config.get("BigQuantumAccumulator", "tier", quantumAccumulatorBigTier).getInt(quantumAccumulatorBigTier);
            quantumAccumulatorBigRightClick    = config.get("BigQuantumAccumulator", "rightClickUse", quantumAccumulatorBigRightClick).getBoolean(quantumAccumulatorBigRightClick);

            industrialBeltEnabled       = config.get("IndustrialBelt", "enabled", industrialBeltEnabled).getBoolean(industrialBeltEnabled);
            industrialBeltId            = config.get("IndustrialBelt", "id", industrialBeltId).getInt(industrialBeltId);
            industrialBeltMaxCharge     = config.get("IndustrialBelt", "maxCharge", industrialBeltMaxCharge).getInt(industrialBeltMaxCharge);
            industrialBeltTransferLimit = config.get("IndustrialBelt", "transferLimit", industrialBeltTransferLimit).getInt(industrialBeltTransferLimit);
            industrialBeltTier          = config.get("IndustrialBelt", "tier", industrialBeltTier).getInt(industrialBeltTier);
            industrialBeltRightClick    = config.get("IndustrialBelt", "rightClickUse", industrialBeltRightClick).getBoolean(industrialBeltRightClick);

            barMinR = getColor(config, "ChargeBar", "minRed", 131);
            barMinG = getColor(config, "ChargeBar", "minGreen", 58);
            barMinB = getColor(config, "ChargeBar", "minBlue", 255);

            barMaxR = getColor(config, "ChargeBar", "maxRed", 10);
            barMaxG = getColor(config, "ChargeBar", "maxGreen", 240);
            barMaxB = getColor(config, "ChargeBar", "maxBlue", 255);
        }
        finally
        {
            config.save();
        }
    }

    @Init
    public void load(FMLInitializationEvent event)
    {
        ItemStack lapotronCrystal = Items.getItem("lapotronCrystal");

        // Creating new items

        // Light Alloy

        if (lightAlloyEnabled)
        {
            lightAlloy = new Item(lightAlloyId - 256);
            lightAlloy.setItemName("plateAlloyLight");
            lightAlloy.setTextureFile(CommonProxy.ITEMS_PNG);
            lightAlloy.setIconIndex(4);
            lightAlloy.setNoRepair();
            LanguageRegistry.addName(lightAlloy, "Light Alloy");
            OreDictionary.registerOre("plateAlloyLight", lightAlloy);
            if (event.getSide() == Side.CLIENT)
            {
                lightAlloy.setCreativeTab(Items.getItem("iridiumPlate").getItem().getCreativeTab());
            }
        }

        // Quantum Pack

        if (quantumPackEnabled)
        {
            quantumPack = new ItemElectricArmor(quantumPackId - 256, EnumArmorMaterial.IRON, proxy.addNewArmourRendererPrefix("ic2/qpack"), 1, quantumPackMaxCharge, quantumPackTransferLimit, quantumPackTier, quantumPackRightClick);
            quantumPack.setItemName("quantumPack");
            quantumPack.setIconIndex(0);
            LanguageRegistry.addName(quantumPack, "Quantum Pack");
            if (event.getSide() == Side.CLIENT)
            {
                quantumPack.setCreativeTab(Items.getItem("lapPack").getItem().getCreativeTab());
                quantumPack.setRarity(Items.getItem("quantumBodyarmor").getRarity());
                proxy.registerIconRenderer(quantumPack);
            }
        }

        // Quantum Accumulator

        if (quantumAccumulatorEnabled)
        {
            quantumAccumulator = new ItemElectricStorage(quantumAccumulatorId - 256, quantumAccumulatorMaxCharge, quantumAccumulatorTransferLimit, quantumAccumulatorTier, quantumAccumulatorRightClick);
            quantumAccumulator.setItemName("quantumAccumulator");
            quantumAccumulator.setIconIndex(1);
            LanguageRegistry.addName(quantumAccumulator, "Quantum Accumulator");
            if (event.getSide() == Side.CLIENT)
            {
                quantumAccumulator.setCreativeTab(lapotronCrystal.getItem().getCreativeTab());
                quantumAccumulator.setRarity(lapotronCrystal.getRarity());
                proxy.registerIconRenderer(quantumAccumulator);
            }
        }

        // Big Quantum Accumulator

        if (quantumAccumulatorBigEnabled)
        {
            quantumAccumulatorBig = new ItemElectricStorage(quantumAccumulatorBigId - 256, quantumAccumulatorBigMaxCharge, quantumAccumulatorBigTransferLimit, quantumAccumulatorBigTier, quantumAccumulatorBigRightClick);
            quantumAccumulatorBig.setItemName("quantumAccumulatorBig");
            quantumAccumulatorBig.setIconIndex(2);
            LanguageRegistry.addName(quantumAccumulatorBig, "Big Quantum Accumulator");
            if (event.getSide() == Side.CLIENT)
            {
                quantumAccumulatorBig.setCreativeTab(lapotronCrystal.getItem().getCreativeTab());
                quantumAccumulatorBig.setRarity(quantumPack.getRarity(null));
                proxy.registerIconRenderer(quantumAccumulatorBig);
            }
        }

        // Industrial Belt

        if (industrialBeltEnabled)
        {
            industrialBelt = new ItemElectricArmor(industrialBeltId - 256, EnumArmorMaterial.IRON, proxy.addNewArmourRendererPrefix("ic2/qpack"), 2, industrialBeltMaxCharge, industrialBeltTransferLimit, industrialBeltTier, industrialBeltRightClick);
            industrialBelt.setItemName("industrialBelt");
            industrialBelt.setIconIndex(3);
            LanguageRegistry.addName(industrialBelt, "Industrial Belt");
            if (event.getSide() == Side.CLIENT)
            {
                ItemStack parent = Items.getItem("batPack");
                industrialBelt.setCreativeTab(parent.getItem().getCreativeTab());
                industrialBelt.setRarity(parent.getRarity());
                proxy.registerIconRenderer(industrialBelt);
            }
        }
    }

    @PostInit
    public void postInit(FMLPostInitializationEvent event)
    {
        // Import items

        ItemStack stackBatPack         = Items.getItem("batPack");
        ItemStack stackLapPack         = Items.getItem("lapPack");
        ItemStack stackIridiumPlate    = Items.getItem("iridiumPlate");
        ItemStack stackLapotronCrystal = Items.getItem("lapotronCrystal");
        ItemStack stackQuantumChest    = Items.getItem("quantumBodyarmor");

        // Try to lookup for aliases in ore dictionary

        OreDictHelper h = new OreDictHelper();

        Object advancedCircuit = h.lookup(Items.getItem("advancedCircuit"));
        Object iridiumPlate    = h.lookup(stackIridiumPlate);
        Object iridium         = h.lookup("ingotIridium", Items.getItem("iridiumOre"));
        Object lapotronCrystal = h.lookup(stackLapotronCrystal);
        Object carbonPlate     = h.lookup(Items.getItem("carbonPlate"));
        Object fiberGlassCable = h.lookup(Items.getItem("glassFiberCableItem"));
        Object tin             = h.lookup("ingotTin", Items.getItem("tinIngot"));
        Object rubber          = h.lookup(Items.getItem("rubber"));
        Object leather         = h.lookup(new ItemStack(Item.leather, 1, 0));

        // Register recipes

        // Light Alloy

        Object alloy = iridiumPlate; // determine whether light alloy or iridium plate should be used
        if (lightAlloy != null)
        {
            Ic2Recipes.addCraftingRecipe(
                    new ItemStack(lightAlloy),
                    new Object[] {
                        " A ", "ABA", " A ",
                        'A', tin,
                        'B', iridium
                    });

            alloy = "plateAlloyLight";
        }

        // Quantum Pack

        if (quantumPack != null)
        {
            ItemStack stack = new ItemStack(quantumPack);

            Ic2Recipes.addCraftingRecipe(
                    stack,
                    new Object[] {
                        " A ", "BCB", " D ",
                        'A', advancedCircuit,
                        'B', alloy,
                        'C', stackLapPack,
                        'D', lapotronCrystal
                    });

            Ic2Recipes.addCraftingRecipe(
                    stack,
                    new Object[] {
                        " D ", "BCB", " A ",
                        'A', advancedCircuit,
                        'B', alloy,
                        'C', stackLapPack,
                        'D', lapotronCrystal
                    });
        }

        // Quantum Accumulator

        ItemStack stackQuantumAccumulator = null;
        if (quantumAccumulator != null)
        {
            stackQuantumAccumulator = new ItemStack(quantumAccumulator);
            Ic2Recipes.addCraftingRecipe(
                    stackQuantumAccumulator,
                    new Object[] {
                        "ABA", "CDC", "CEC",
                        'A', carbonPlate,
                        'B', fiberGlassCable,
                        'C', rubber,
                        'D', lapotronCrystal,
                        'E', alloy
                    });
        }

        // Big Quantum Accumulator

        if (quantumAccumulatorBig != null)
        {
            if (stackQuantumAccumulator != null)
            {
                Ic2Recipes.addCraftingRecipe(
                        new ItemStack(quantumAccumulatorBig),
                        new Object[] {
                            "ABA", "CCC", "CCC",
                            'A', fiberGlassCable,
                            'B', carbonPlate,
                            'C', stackQuantumAccumulator
                        });
            }
            else
            {
                Ic2Recipes.addCraftingRecipe(
                        new ItemStack(quantumAccumulatorBig),
                        new Object[] {
                            "ABA", "CCC", "CCC",
                            'A', iridiumPlate,
                            'B', carbonPlate,
                            'C', lapotronCrystal
                        });
            }
        }

        // Industrial Belt

        if (industrialBelt != null)
        {
            ItemStack stack = new ItemStack(industrialBelt);
            ItemStack reBattery = Items.getItem("reBattery");

            Ic2Recipes.addCraftingRecipe(
                    stack,
                    new Object[] {
                        "RLL", "DDD",
                        'R', rubber,
                        'L', leather,
                        'D', h.lookup(reBattery),
                    });

            Ic2Recipes.addCraftingRecipe(
                    stack,
                    new Object[] {
                        "RLL", "DDD",
                        'R', rubber,
                        'L', leather,
                        'D', h.lookup(Items.getItem("chargedReBattery"))
                    });

            // Partial decrafting recipe

            Ic2Recipes.addShapelessCraftingRecipe(
                    new ItemStack(reBattery.getItem(), 3),
                    new Object[] {
                        stack
                    });
        }

        // Cleanup references

        lightAlloy = null;
        quantumPack = null;
        quantumAccumulator = null;
        quantumAccumulatorBig = null;
        industrialBelt = null;
    }

    // Utils

    public static void chargeInventoryItem(ItemStack src, EntityPlayer player)
    {
        if (src.getItem() instanceof IElectricItem)
        {
            IElectricItem e = (IElectricItem) src.getItem();
            int srcTransferLimit = e.getTransferLimit();
            int srcTier = e.getTier();

            // Iterate through items
            for (ItemStack dst : player.inventory.mainInventory)
            {
                // Check whether it is suitable item
                if ((dst != null) && (dst.getItem() instanceof IElectricItem) && (dst != src))
                {
                    e = (IElectricItem) dst.getItem();
                    int dstTier = e.getTier();

                    int count = ElectricItem.discharge(src, Math.min(srcTransferLimit, e.getTransferLimit()), dstTier, true, true); // determine how much energy can be transferred
                    count = ElectricItem.charge(dst, count, srcTier, true, false); // charge target item
                    ElectricItem.discharge(src, count, dstTier, true, false); // actually discharge source

                    if (count != 0) break; // finish if item successfully charged
                }
            }
        }
    }

    @SideOnly(Side.CLIENT)
    public static void getCreativeItems(Item item, List list)
    {
        ItemStack empty = new ItemStack(item);
        ElectricItem.discharge(empty, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        list.add(empty);

        ItemStack full = new ItemStack(item);
        ElectricItem.charge(full, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        list.add(full);
    }
}
