package mods.NetworkAnchor;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeChunkManager.Ticket;

public class ChunkloadCallback implements ForgeChunkManager.OrderedLoadingCallback
{
    @Override
    public void ticketsLoaded(List<Ticket> tickets, World world)
    {
        Set<BlockCoords> anchors = new TreeSet<BlockCoords>();

        // iterate through tickets
        for (Ticket ticket : tickets)
        {
            // get anchor coords from ticket
            int x = ticket.getModData().getInteger("x");
            int y = ticket.getModData().getInteger("y");
            int z = ticket.getModData().getInteger("z");

            // check whether entity at specified coords is network anchor
            TileEntity tile = world.getBlockTileEntity(x, y, z);
            if (tile != null && tile instanceof TileEntityNetworkAnchor)
            {
                // add ticket to anchor ticket list
                ((TileEntityNetworkAnchor) tile).tickets.add(ticket);

                // add anchor to set of anchors
                BlockCoords anchor = new BlockCoords(x, y, z);
                anchors.add(anchor);
            }
        }

        // iterate discovered anchors and restore chunks geometry
        for (BlockCoords anchor : anchors)
        {
            TileEntity tile = world.getBlockTileEntity(anchor.x, anchor.y, anchor.z);
            if (tile != null && !tile.isInvalid() && tile instanceof TileEntityNetworkAnchor)
            {
                ((TileEntityNetworkAnchor) tile).init(true);
            }
        }
    }

    @Override
    public List<Ticket> ticketsLoaded(List<Ticket> tickets, World world, int maxTicketCount)
    {
        List<Ticket> validTickets = new LinkedList<Ticket>();

        for (Ticket ticket : tickets)
        {
            int x = ticket.getModData().getInteger("x");
            int y = ticket.getModData().getInteger("y");
            int z = ticket.getModData().getInteger("z");

            if (world.getBlockId(x, y, z) == NetworkAnchor.blockNetworkAnchor.blockID) validTickets.add(ticket);
        }

        return validTickets;
    }
}
