package mods.NetworkAnchor;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerNetworkAnchor extends Container
{
    public TileEntityNetworkAnchor tile;
    // *** Synchronization of all this fields are moved to tile entity class ***

    public ContainerNetworkAnchor(InventoryPlayer inventory, TileEntityNetworkAnchor tile)
    {
        // Remember associated tile entity
        this.tile = tile;

        // Add universal/upgrade slots
        addSlotToContainer(new Slot(tile, 0, 152, 8));
        addSlotToContainer(new Slot(tile, 1, 152, 26));
        addSlotToContainer(new Slot(tile, 2, 152, 44));
        addSlotToContainer(new Slot(tile, 3, 152, 62));

        // Player inventory slots
        for (int x = 0; x < 3; x++)
            for (int y = 0; y < 9; y++)
                addSlotToContainer(new Slot(inventory, y + x * 9 + 9, 8 + y * 18, 84 + x * 18));

        // Player hotbar slots
        for (int x = 0; x < 9; x++)
            addSlotToContainer(new Slot(inventory, x, 8 + x * 18, 142));
    }

    @Override
    public boolean canInteractWith(EntityPlayer player)
    {
        return tile.isUseableByPlayer(player);
    }

    /**
     * Called when a player shift-clicks on a slot. Slot index are ordered the same way as they created in the constructor.
     *
     * @param player who shift-clicked slot
     * @param slotIndex on which player is shift-clicked
     * @return ItemStack to put into shift-clicked slot or null if you want to leave Slot content as is.
     */
    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex)
    {
        ItemStack var3 = null;
        Slot slot = (Slot) inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack())
        {
            ItemStack stack = slot.getStack();
            var3 = stack.copy();

            if (slotIndex >= 4)
            {
                if (tile.isStackValidForSlot(slotIndex, stack))
                {
                    if (!mergeItemStack(stack, 0, 4, false)) return null;
                }
                else if (slotIndex >= 4 && slotIndex < 31)
                {
                    if (!mergeItemStack(stack, 31, 40, false)) return null;
                }
                else if (slotIndex >= 31 && slotIndex < 40 && !mergeItemStack(stack, 4, 31, false))
                {
                    return null;
                }
            }
            else if (!mergeItemStack(stack, 4, 40, false))
            {
                return null;
            }

            if (stack.stackSize == 0)
                slot.putStack(null);
            else
                slot.onSlotChanged();

            if (stack.stackSize == var3.stackSize) return null;
            slot.onPickupFromSlot(player, stack);
        }

        return var3;
    }
}
