package mods.NetworkAnchor;

import ic2.api.network.NetworkHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

import org.lwjgl.opengl.GL11;

public class GuiNetworkAnchor extends GuiContainer
{
    TileEntityNetworkAnchor tile;
    GuiButtonFix btnScan;

    public GuiNetworkAnchor(InventoryPlayer inventory, TileEntityNetworkAnchor tile)
    {
        super(new ContainerNetworkAnchor(inventory, tile));
        this.tile = tile;
    }

    public String getEnabledDisabled()
    {
        return tile.scan ? "gui.networkAnchor.enabled" : "gui.networkAnchor.disabled";
    }

    @Override
    public void initGui()
    {
        super.initGui();
        btnScan = new GuiButtonFix(0, guiLeft + 91, guiTop + 12, 50, 18, getEnabledDisabled());
        buttonList.add(btnScan);

        buttonList.add(new GuiButtonFix(1, guiLeft + 91, guiTop + 34, 23, 18, "gui.networkAnchor.decArea"));
        buttonList.add(new GuiButtonFix(2, guiLeft + 118, guiTop + 34, 23, 18, "gui.networkAnchor.incArea"));

        buttonList.add(new GuiButtonFix(3, guiLeft + 91, guiTop + 56, 50, 18, "gui.networkAnchor.restart"));
    }

    @Override
    protected void actionPerformed(GuiButton button)
    {
        super.actionPerformed(button);
        tile.onNetworkEvent(null, button.id);
        NetworkHelper.initiateClientTileEntityEvent(tile, button.id);
        btnScan.displayString = getEnabledDisabled();
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY)
    {
        fontRenderer.drawString(StatCollector.translateToLocal(tile.getInvName()), 8, 6, 4210752);
        fontRenderer.drawString(StatCollector.translateToLocal("gui.networkAnchor.scan"), 8, 16 + 1, 4210752);
        btnScan.displayString = getEnabledDisabled();

        int d = 2 * tile.area + 1;
        fontRenderer.drawString(String.format(StatCollector.translateToLocal("gui.networkAnchor.area") + "%dx%d", d, d), 8, 26 + 2, 4210752);
        fontRenderer.drawString(String.format(StatCollector.translateToLocal("gui.networkAnchor.tiles") + "%d", tile.tilesFound), 8, 36 + 3, 4210752);

        if (tile.ticketsUsed > 0 && tile.chunksForced != tile.chunksFound)
            fontRenderer.drawString(String.format(StatCollector.translateToLocal("gui.networkAnchor.chunks") + "%d/%d", tile.chunksForced, tile.chunksFound), 8, 46 + 4, 4210752);
        else
            fontRenderer.drawString(String.format(StatCollector.translateToLocal("gui.networkAnchor.chunks") + "%d", tile.chunksFound), 8, 46 + 4, 4210752);

        fontRenderer.drawString(String.format(StatCollector.translateToLocal("gui.networkAnchor.tickets") + "%d", tile.ticketsUsed), 8, 56 + 5, 4210752);
        fontRenderer.drawString(StatCollector.translateToLocal("container.inventory"), 8, ySize - 96 + 2, 4210752);

        if (tile.energyEnabled && isPointInRegion(146, 8, 4, 70, mouseX, mouseY))
        {
            GL11.glPushMatrix();
            drawCreativeTabHoveringText(String.format("%d/%d EU", tile.energy, tile.maxEnergy), mouseX - guiLeft, mouseY - guiTop);
            GL11.glPopMatrix();

            // *** This thing is crashing :( ***
            // List<String> list = new ArrayList<String>(1);
            // list.add(String.format("%d/%d EU", tile.energy, tile.energy));
            // drawHoveringText(list, mouseX - guiLeft, mouseY - guiTop, fontRenderer);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3)
    {
        mc.renderEngine.bindTexture("/mods/NetworkAnchor/gui/gui.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        drawTexturedModalRect(guiLeft, guiTop, 0, 0, xSize, ySize);

        // Draw charge bar
        if (tile.energyEnabled && tile.initialized)
        {
            int h = (int) Math.round(tile.energy * 70.0D / tile.maxEnergy);
            if (h < 0) h = 0;
            if (h > 70) h = 70; // clamp overcharge
            drawTexturedModalRect(guiLeft + 146, // x
                    guiTop + 8 + 70 - h, // y
                    176, // u
                    0 + 70 - h, // v
                    4, // width
                    h); // height
        }
    }
}
