package mods.NetworkAnchor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictHelper
{
    public Set<String> oreNames;

    public OreDictHelper()
    {
        oreNames = new HashSet<String>(Arrays.asList(OreDictionary.getOreNames()));
    }

    public Object lookup(String preffered, ItemStack defaultStack)
    {
        if (oreNames.contains(preffered)) return preffered;
        return lookup(defaultStack);
    }

    public Object lookup(ItemStack stack)
    {
        int id = OreDictionary.getOreID(stack);
        if (id == -1) return stack;
        String name = OreDictionary.getOreName(id);
        if (name == "Unknown") return stack;
        return name;
    }

    /* for debug only
    public static void dumpOreNames()
    {
        Logger log = Logger.getLogger(Loader.instance().activeModContainer().getModId());
        log.info("Ore names:");
        String[] oreNames = OreDictionary.getOreNames();
        Arrays.sort(oreNames);
        for (String s : oreNames) log.info("\"" + s + "\"");
    }*/
}
