package mods.NetworkAnchor;

public class ChunkCoords implements Comparable<ChunkCoords>
{
    public final int x, z;

    public ChunkCoords(int blockX, int blockZ)
    {
        x = blockX >> 4;
        z = blockZ >> 4;
    }

    @Override
    public int compareTo(ChunkCoords other)
    {
        if (x < other.x) return -1;
        if (x > other.x) return 1;
        if (z < other.z) return -1;
        if (z > other.z) return 1;
        return 0;
    }
}
