package mods.NetworkAnchor;

import java.util.Random;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class BlockNetworkAnchor extends BlockContainer
{
    private Random anchorRand = new Random();
    private Icon[] icons = new Icon[3];

    public BlockNetworkAnchor(int id, Material material)
    {
        super(id, material);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister iconRegister)
    {
        for (int i = 0; i <= 2; i++)
        {
            icons[i] = iconRegister.registerIcon("NetworkAnchor:networkAnchor_" + i);
        }
    }

    @Override
    @SideOnly(Side.CLIENT)
    public Icon getIcon(int side, int metadata)
    {
        return icons[side >= 2 ? 2 : side];
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9)
    {
        super.onBlockActivated(world, x, y, z, player, par6, par7, par8, par9);
        if (player.isSneaking()) return false; // Drop through if player is sneaking
        if (!world.isRemote) player.openGui(NetworkAnchor.instance, 0, world, x, y, z);
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World world)
    {
        return new TileEntityNetworkAnchor();
    }

    @Override
    public boolean canBeReplacedByLeaves(World world, int x, int y, int z)
    {
        return false;
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, int par5, int par6)
    {
        // Drop items from IInventory
        TileEntity tile = world.getBlockTileEntity(x, y, z);
        if (tile == null || tile instanceof IInventory == false) return;
        IInventory inventory = (IInventory) tile;
        for (int i = 0; i < inventory.getSizeInventory(); i++)
        {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null) continue;

            float dx = anchorRand.nextFloat() * 0.8F + 0.1F;
            float dy = anchorRand.nextFloat() * 0.8F + 0.1F;
            float dz = anchorRand.nextFloat() * 0.8F + 0.1F;

            while (stack.stackSize > 0)
            {
                int count = anchorRand.nextInt(21) + 10;

                if (count > stack.stackSize) count = stack.stackSize;

                stack.stackSize -= count;
                EntityItem entity = new EntityItem(world, x + dx, y + dy, z + dz, new ItemStack(stack.itemID, count, stack.getItemDamage()));

                if (stack.hasTagCompound())
                {
                    entity.getEntityItem().setTagCompound((NBTTagCompound) stack.getTagCompound().copy());
                }

                float var15 = 0.05F;
                entity.motionX = (float) anchorRand.nextGaussian() * var15;
                entity.motionY = (float) anchorRand.nextGaussian() * var15 + 0.2F;
                entity.motionZ = (float) anchorRand.nextGaussian() * var15;
                world.spawnEntityInWorld(entity);
            }
        }

        super.breakBlock(world, x, y, z, par5, par6);
    }
}
