package mods.NetworkAnchor;

import ic2.api.item.Items;
import ic2.api.recipe.Recipes;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;

@Mod(modid = "NetworkAnchor", name = "NetworkAnchor", version = "0.09", dependencies = "required-after:IC2; after:GregTech_Addon; after:IC2CA")
@NetworkMod(clientSideRequired = true, serverSideRequired = true)
public class NetworkAnchor
{
    // The instance of mod that Forge uses.
    @Instance("NetworkAnchor")
    public static NetworkAnchor instance;

    // Says where the client and server 'proxy' code is loaded.
    @SidedProxy(clientSide = "mods.NetworkAnchor.ClientProxy", serverSide = "mods.NetworkAnchor.CommonProxy")
    public static CommonProxy proxy;

    // Config variables
    public static int networkAnchorID = 777;

    /**
     * Energy consumption variables.
     */
    public static int energyBase = 0;
    public static int energyPerTile = 0;
    public static int energyPerChunk = 4;

    /**
     * Helper variable - indicates whether potential energy consumption may be non zero, e.g. enables or disables energy consumption.
     */
    public static boolean energyEnabled = false;

    /**
     * Determines whether hard GregTech recipes is enabled.
     */
    public static boolean hardGregTechRecipe = true;

    // Blocks
    public static BlockNetworkAnchor blockNetworkAnchor;

    @PreInit
    public void preInit(FMLPreInitializationEvent event)
    {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try
        {
            config.load();

            networkAnchorID = config.getBlock("NetworkAnchor", "BlockID", networkAnchorID).getInt(networkAnchorID);

            hardGregTechRecipe = config.get("NetworkAnchor", "HardGregTechRecipe", hardGregTechRecipe).getBoolean(hardGregTechRecipe);

            energyBase = config.get("NetworkAnchor", "EnergyBase", energyBase).getInt(energyBase);
            if (energyBase < 0) energyBase = 0; // sentinel

            energyPerTile = config.get("NetworkAnchor", "EnergyPerTile", energyPerTile).getInt(energyPerTile);
            if (energyPerTile < 0) energyPerTile = 0; // sentinel

            energyPerChunk = config.get("NetworkAnchor", "EnergyPerChunk", energyPerChunk).getInt(energyPerChunk);
            if (energyPerChunk < 0) energyPerChunk = 0; // sentinel

            // Update helper variable
            energyEnabled = energyBase != 0 || energyPerTile != 0 || energyPerChunk != 0;
        }
        finally
        {
            if (config.hasChanged()) config.save();
        }
    }

    @Init
    public void load(FMLInitializationEvent event)
    {
        // Create Network Anchor block
        blockNetworkAnchor = new BlockNetworkAnchor(networkAnchorID, new Material(MapColor.ironColor));
        blockNetworkAnchor.setStepSound(Block.soundMetalFootstep);
        blockNetworkAnchor.setHardness(2.0F);
        MinecraftForge.setBlockHarvestLevel(blockNetworkAnchor, 0, "pickaxe", 0);
        blockNetworkAnchor.setUnlocalizedName("networkAnchor");
        if (event.getSide() == Side.CLIENT) blockNetworkAnchor.setCreativeTab(Items.getItem("machine").getItem().getCreativeTab());
        GameRegistry.registerBlock(blockNetworkAnchor, "networkAnchor");
        GameRegistry.registerTileEntity(TileEntityNetworkAnchor.class, "TileEntityNetworkAnchor");

        // Register GUI handler
        NetworkRegistry.instance().registerGuiHandler(instance, new GuiHandler());

        // Register chunk loading callback
        ForgeChunkManager.setForcedChunkLoadingCallback(instance, new ChunkloadCallback());

        // Language data - for client only
        proxy.loadLangs();
    }

    @PostInit
    public void postInit(FMLPostInitializationEvent event)
    {
        OreDictHelper h = new OreDictHelper();

        boolean recipeAdded = false;

        // Try to add hard recipe if there is GregTech available
        if (hardGregTechRecipe && isGregTechAvailable())
        {
            Object display = h.lookup(getGregTechItem(3, 1, 4));
            Object dataOrb = h.lookup(getGregTechItem(43, 1, 0));
            Object highlyAdvancedMachineBlock = h.lookup(getGregTechBlock(0, 1, 10));

            if (display != null && dataOrb != null && highlyAdvancedMachineBlock != null)
            {
                Recipes.advRecipes.addRecipe(
                        new ItemStack(blockNetworkAnchor),
                        new Object[] {
                            "IDI", "MOM", "TFT",
                            'I', h.lookup(Items.getItem("iridiumPlate")),
                            'D', display,
                            'O', dataOrb,
                            'M', highlyAdvancedMachineBlock,
                            'T', h.lookup(Items.getItem("hvTransformer")),
                            'F', h.lookup(Items.getItem("glassFiberCableItem"))
                            });

                recipeAdded = true;
            }
        }

        // Otherwise add vanilla recipe
        if (!recipeAdded)
        {
            Object machine = h.lookup("rawMachineTier00", Items.getItem("machine"));
            Object circuit = h.lookup("circuitTier01", Items.getItem("electronicCircuit"));
            Object copperCable = h.lookup(Items.getItem("insulatedCopperCableItem"));

            Recipes.advRecipes.addRecipe(
                    new ItemStack(blockNetworkAnchor),
                    new Object[] {
                        " A ", " B ", " C ",
                        'A', circuit,
                        'B', machine,
                        'C', copperCable
                        });

            Recipes.advRecipes.addRecipe(
                    new ItemStack(blockNetworkAnchor),
                    new Object[] {
                        " A ", " B ", " C ",
                        'A', copperCable,
                        'B', machine,
                        'C', circuit
                        });
        }

        // Import upgrade modules

        // Classic IC2

        UpgradeDictionary.put(Items.getItem("overclockerUpgrade"), UpgradeDictionary.SPEED, 1, 1);
        UpgradeDictionary.put(Items.getItem("transformerUpgrade"), UpgradeDictionary.TIER, 1, 1);
        UpgradeDictionary.put(Items.getItem("energyStorageUpgrade"), UpgradeDictionary.STORAGE, 10000, 1);

        // GregTech

        if (isGregTechAvailable())
        {
            UpgradeDictionary.put(getGregTechItem(3, 1, 12), UpgradeDictionary.STORAGE, 100000, 2); // Energy Crystal Storage Upgrade
            UpgradeDictionary.put(getGregTechItem(3, 1, 13), UpgradeDictionary.STORAGE, 1000000, 3); // Lapotron Crystal Storage Upgrade
            UpgradeDictionary.put(getGregTechItem(3, 1, 14), UpgradeDictionary.STORAGE, 10000000, 4); // Energy Orb Storage Upgrade
            UpgradeDictionary.put(getGregTechItem(3, 1, 26), UpgradeDictionary.STORAGE, 100000, 1); // Lithium Storage Upgrade
            UpgradeDictionary.put(getGregTechItem(3, 1, 27), UpgradeDictionary.TIER, 3, 1); // HV Transformer Upgrade
        }

        // ComboArmors

        UpgradeDictionary.put(getComboArmorsItem("energyMk2"), UpgradeDictionary.STORAGE, 100000, 2);
        UpgradeDictionary.put(getComboArmorsItem("energyMk3"), UpgradeDictionary.STORAGE, 1000000, 3);
    }

    // External APIs

    // GregTech

    public static boolean isGregTechAvailable()
    {
        try
        {
            return ((Boolean) Class.forName("gregtechmod.api.GregTech_API").getMethod("isGregTechLoaded").invoke(null)).booleanValue();
        }
        catch (Exception e)
        {
            return false;
        }
    }

    public static ItemStack getGregTechBlock(int aIndex, int aAmount, int aMeta)
    {
        try
        {
            return (ItemStack) Class.forName("gregtechmod.api.GregTech_API").getMethod("getGregTechBlock", int.class, int.class, int.class).invoke(null, aIndex, aAmount, aMeta);
        }
        catch (Exception e)
        {
            return null;
        }
    }

    public static ItemStack getGregTechItem(int aIndex, int aAmount, int aMeta)
    {
        try
        {
            return (ItemStack) Class.forName("gregtechmod.api.GregTech_API").getMethod("getGregTechItem", int.class, int.class, int.class).invoke(null, aIndex, aAmount, aMeta);
        }
        catch (Exception e)
        {
            return null;
        }
    }

    // ComboArmors

    public static ItemStack getComboArmorsItem(String item)
    {
        try
        {
            return (ItemStack) Class.forName("ic2ca.api.Ic2caItemsApi").getMethod("getItemByName", String.class).invoke(null, item);
        }
        catch (Exception e)
        {
            return null;
        }
    }
}
