/*
 * Decompiled with CFR 0.152.
 */
package mods.mffs.common.block;

import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.mffs.api.IFieldTeleporter;
import mods.mffs.api.IForceFieldBlock;
import mods.mffs.api.PointXYZ;
import mods.mffs.common.ForceFieldBlockStack;
import mods.mffs.common.ForceFieldTyps;
import mods.mffs.common.Functions;
import mods.mffs.common.Linkgrid;
import mods.mffs.common.MFFSDamageSource;
import mods.mffs.common.ModularForceFieldSystem;
import mods.mffs.common.SecurityHelper;
import mods.mffs.common.SecurityRight;
import mods.mffs.common.WorldMap;
import mods.mffs.common.item.ItemCardPowerLink;
import mods.mffs.common.multitool.ItemDebugger;
import mods.mffs.common.tileentity.TileEntityCapacitor;
import mods.mffs.common.tileentity.TileEntityForceField;
import mods.mffs.common.tileentity.TileEntityProjector;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockForceField
extends BlockContainer
implements IForceFieldBlock {
    public static int renderer;
    public int posx;
    public int posy;
    public int posz;
    private final Icon[] icons = new Icon[4];

    public BlockForceField(int i) {
        super(i, Material.field_76264_q);
        this.func_71875_q();
        this.func_71894_b(999.0f);
        this.func_71907_b(true);
    }

    public void func_94332_a(IconRegister iconRegister) {
        this.icons[0] = iconRegister.func_94245_a("mffs:Field/Default" + (ModularForceFieldSystem.graphicsStyle == 1 ? "_32" : ""));
        this.icons[1] = iconRegister.func_94245_a("mffs:Field/Zapper" + (ModularForceFieldSystem.graphicsStyle == 1 ? "_32" : ""));
        this.icons[2] = iconRegister.func_94245_a("mffs:Field/Area" + (ModularForceFieldSystem.graphicsStyle == 1 ? "_32" : ""));
        this.icons[3] = iconRegister.func_94245_a("mffs:Field/Containment" + (ModularForceFieldSystem.graphicsStyle == 1 ? "_32" : ""));
        this.field_94336_cN = this.icons[0];
    }

    public void func_71861_g(World world, int i, int j, int k) {
        this.posx = i;
        this.posy = j;
        this.posz = k;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71856_s_() {
        TileEntityForceField ForceField;
        if (ModularForceFieldSystem.proxy.getClientWorld().func_72805_g(this.posx, this.posy, this.posz) == ForceFieldTyps.Camouflage.ordinal() && (ForceField = (TileEntityForceField)ModularForceFieldSystem.proxy.getClientWorld().func_72796_p(this.posx, this.posy, this.posz)) != null) {
            if (ForceField.getTexturid(1) == 67 || ForceField.getTexturid(1) == 205) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public int func_71857_b() {
        return ModularForceFieldSystem.MFFSRENDER_ID;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    protected boolean func_71906_q_() {
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int blockid) {
        if (blockid != ModularForceFieldSystem.MFFSFieldblock.field_71990_ca) {
            for (int x1 = -1; x1 <= 1; ++x1) {
                for (int y1 = -1; y1 <= 1; ++y1) {
                    for (int z1 = -1; z1 <= 1; ++z1) {
                        if (world.func_72798_a(x + x1, y + y1, z + z1) == ModularForceFieldSystem.MFFSFieldblock.field_71990_ca || world.func_72798_a(x + x1, y + y1, z + z1) != 0) continue;
                        this.func_71852_a(world, x + x1, y + y1, z + z1, 0, 0);
                    }
                }
            }
        }
    }

    public void func_71852_a(World world, int i, int j, int k, int a, int b) {
        TileEntityProjector Projector;
        ForceFieldBlockStack ffworldmap = WorldMap.getForceFieldWorld(world).getForceFieldStackMap(new PointXYZ(i, j, k, world).hashCode());
        if (ffworldmap != null && !ffworldmap.isEmpty() && (Projector = (TileEntityProjector)Linkgrid.getWorldMap(world).getProjektor().get(ffworldmap.getProjectorID())) != null) {
            if (!Projector.isActive()) {
                ffworldmap.removebyProjector(ffworldmap.getProjectorID());
            } else {
                world.func_94575_c(i, j, k, ModularForceFieldSystem.MFFSFieldblock.field_71990_ca);
                world.func_72921_c(i, j, k, ffworldmap.getTyp(), 2);
                world.func_72845_h(i, j, k);
                ffworldmap.setSync(true);
                if (ffworldmap.getTyp() == 1) {
                    Projector.consumePower(ModularForceFieldSystem.forceFieldBlockCost * ModularForceFieldSystem.forceFieldBlockCreateModifier, false);
                } else {
                    Projector.consumePower(ModularForceFieldSystem.forceFieldBlockCost * ModularForceFieldSystem.forceFieldBlockCreateModifier * ModularForceFieldSystem.forceFieldBlockZapperModifier, false);
                }
            }
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return false;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        boolean debugger = item instanceof ItemDebugger;
        if (!(item instanceof IFieldTeleporter) && !debugger) {
            return false;
        }
        WorldMap.ForceFieldWorld wff = WorldMap.getForceFieldWorld(world);
        ForceFieldBlockStack ffworldmap = wff.getForceFieldStackMap(new PointXYZ(x, y, z, world));
        if (ffworldmap != null) {
            int Sec_Gen_ID = -1;
            int First_Gen_ID = ffworldmap.getGenratorID();
            int First_Pro_ID = ffworldmap.getProjectorID();
            TileEntityCapacitor generator = (TileEntityCapacitor)Linkgrid.getWorldMap(world).getCapacitor().get(First_Gen_ID);
            TileEntityProjector projector = (TileEntityProjector)Linkgrid.getWorldMap(world).getProjektor().get(First_Pro_ID);
            if (projector != null && generator != null) {
                if (debugger) {
                    projector.setBurnedOut(true);
                    player.func_71035_c("Forcefield projector burnt out. Projector location: (" + projector.field_70329_l + "," + projector.field_70330_m + "," + projector.field_70327_n + ")");
                    return true;
                }
                if (projector.isActive()) {
                    boolean passThrough = false;
                    switch (projector.getaccesstyp()) {
                        case 0: {
                            passThrough = false;
                            String[] ops = ModularForceFieldSystem.Admin.split(";");
                            for (int i = 0; i <= ops.length - 1; ++i) {
                                if (!player.field_71092_bJ.equalsIgnoreCase(ops[i])) continue;
                                passThrough = true;
                            }
                            break;
                        }
                        case 1: {
                            passThrough = true;
                            break;
                        }
                        case 2: {
                            passThrough = SecurityHelper.isAccessGranted(generator, player, world, SecurityRight.FFB);
                            break;
                        }
                        case 3: {
                            passThrough = SecurityHelper.isAccessGranted(projector, player, world, SecurityRight.FFB);
                        }
                    }
                    if (passThrough) {
                        int typ = 99;
                        int ymodi = 0;
                        int lm = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                        int i1 = Math.round(player.field_70125_A);
                        if (i1 >= 65) {
                            typ = 1;
                        } else if (i1 <= -65) {
                            typ = 0;
                        } else if (lm == 0) {
                            typ = 2;
                        } else if (lm == 1) {
                            typ = 5;
                        } else if (lm == 2) {
                            typ = 3;
                        } else if (lm == 3) {
                            typ = 4;
                        }
                        int counter = 0;
                        while (Sec_Gen_ID != 0) {
                            Sec_Gen_ID = wff.isExistForceFieldStackMap(x, y, z, counter, typ, world);
                            if (Sec_Gen_ID == 0) continue;
                            ++counter;
                        }
                        if (First_Gen_ID != wff.isExistForceFieldStackMap(x, y, z, counter - 1, typ, world)) {
                            Functions.ChattoPlayer(player, LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
                            return false;
                        }
                        switch (typ) {
                            case 0: {
                                y += counter;
                                ymodi = -1;
                                break;
                            }
                            case 1: {
                                y -= counter;
                                ymodi = 1;
                                break;
                            }
                            case 2: {
                                z += counter;
                                break;
                            }
                            case 3: {
                                z -= counter;
                                break;
                            }
                            case 4: {
                                x += counter;
                                break;
                            }
                            case 5: {
                                x -= counter;
                            }
                        }
                        Functions.ChattoPlayer(player, LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessGranted"));
                        if (counter >= 0 && counter <= 5) {
                            if ((world.func_72803_f(x, y, z).func_76224_d() || world.func_72799_c(x, y, z)) && (world.func_72803_f(x, y - ymodi, z).func_76224_d() || world.func_72799_c(x, y - ymodi, z))) {
                                if (y - ymodi <= 0) {
                                    Functions.ChattoPlayer(player, LanguageRegistry.instance().getStringLocalization("fieldSecurity.voidNotAllowed"));
                                } else {
                                    IFieldTeleporter teleporter = (IFieldTeleporter)item;
                                    if (teleporter.canFieldTeleport(player, stack, ModularForceFieldSystem.forceFieldTransportCost)) {
                                        teleporter.onFieldTeleportSuccess(player, stack, ModularForceFieldSystem.forceFieldTransportCost);
                                        player.func_70634_a((double)x + 0.5, (double)(y - ymodi), (double)z + 0.5);
                                    } else {
                                        teleporter.onFieldTeleportFailed(player, stack, ModularForceFieldSystem.forceFieldTransportCost);
                                    }
                                }
                            } else {
                                Functions.ChattoPlayer(player, LanguageRegistry.instance().getStringLocalization("fieldSecurity.detectedObstacle"));
                            }
                        } else {
                            Functions.ChattoPlayer(player, LanguageRegistry.instance().getStringLocalization("fieldSecurity.fieldTooStrong"));
                        }
                    } else {
                        Functions.ChattoPlayer(player, LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
                    }
                }
            } else if (projector != null && projector.func_70301_a(projector.getPowerlinkSlot()) != null && !(projector.func_70301_a(projector.getPowerlinkSlot()).func_77973_b() instanceof ItemCardPowerLink)) {
                Functions.ChattoPlayer(player, LanguageRegistry.instance().getStringLocalization("fieldSecurity.invalidItemInPowerLink"));
            }
        }
        return false;
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        ForceFieldBlockStack ffworldmap = WorldMap.getForceFieldWorld(world).getForceFieldStackMap(new PointXYZ(x, y, z, world).hashCode());
        if (ffworldmap != null && !ModularForceFieldSystem.adventureMapMode) {
            TileEntityProjector projector = (TileEntityProjector)Linkgrid.getWorldMap(world).getProjektor().get(ffworldmap.getProjectorID());
            if (projector != null) {
                switch (projector.getaccesstyp()) {
                    case 0: {
                        player.func_70097_a(MFFSDamageSource.fieldShock, 10);
                        Functions.ChattoPlayer(player, LanguageRegistry.instance().getStringLocalization("field.highEnergyField"));
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (SecurityHelper.isAccessGranted(projector, player, world, SecurityRight.SR)) break;
                        player.func_70097_a(MFFSDamageSource.fieldShock, 10);
                        Functions.ChattoPlayer(player, LanguageRegistry.instance().getStringLocalization("field.highEnergyField"));
                    }
                }
            }
            if (!SecurityHelper.isAccessGranted(projector, player, world, SecurityRight.SR)) {
                player.func_70097_a(MFFSDamageSource.fieldShock, 10);
                Functions.ChattoPlayer(player, LanguageRegistry.instance().getStringLocalization("field.highEnergyField"));
            }
        }
        Random random = null;
        this.func_71847_b(world, x, y, z, random);
    }

    public AxisAlignedBB func_71872_e(World world, int i, int j, int k) {
        if (world.func_72805_g(i, j, k) == ForceFieldTyps.Zapper.ordinal()) {
            float f = 0.0625f;
            return AxisAlignedBB.func_72330_a((double)((float)i + f), (double)((float)j + f), (double)((float)k + f), (double)((float)(i + 1) - f), (double)((float)(j + 1) - f), (double)((float)(k + 1) - f));
        }
        return AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
    }

    public AxisAlignedBB func_71911_a_(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 0), (double)(j + 0), (double)(k + 0));
    }

    public void func_71869_a(World world, int i, int j, int k, Entity entity) {
        TileEntityProjector projector;
        ForceFieldBlockStack ffworldmap;
        if (world.func_72805_g(i, j, k) == ForceFieldTyps.Zapper.ordinal()) {
            if (entity instanceof EntityLiving) {
                entity.func_70097_a(MFFSDamageSource.fieldShock, 10);
            }
        } else if (entity instanceof EntityPlayer && (ffworldmap = WorldMap.getForceFieldWorld(world).getorcreateFFStackMap(i, j, k, world)) != null && (projector = (TileEntityProjector)Linkgrid.getWorldMap(world).getProjektor().get(ffworldmap.getProjectorID())) != null) {
            boolean passtrue = false;
            switch (projector.getaccesstyp()) {
                case 0: {
                    passtrue = false;
                    if (!ModularForceFieldSystem.Admin.equals(((EntityPlayer)entity).field_71092_bJ)) break;
                    passtrue = true;
                    break;
                }
                case 1: {
                    passtrue = true;
                    break;
                }
                case 2: {
                    TileEntityCapacitor generator = (TileEntityCapacitor)Linkgrid.getWorldMap(world).getCapacitor().get(ffworldmap.getGenratorID());
                    passtrue = SecurityHelper.isAccessGranted(generator, (EntityPlayer)entity, world, SecurityRight.FFB);
                    break;
                }
                case 3: {
                    passtrue = SecurityHelper.isAccessGranted(projector, (EntityPlayer)entity, world, SecurityRight.FFB);
                }
            }
            if (!passtrue) {
                ((EntityPlayer)entity).func_70097_a(MFFSDamageSource.fieldShock, 20);
            } else {
                ((EntityPlayer)entity).func_70097_a(MFFSDamageSource.fieldShock, 1);
            }
            Functions.ChattoPlayer((EntityPlayer)entity, LanguageRegistry.instance().getStringLocalization("field.highEnergyField"));
        }
    }

    public int func_71925_a(Random random) {
        return 0;
    }

    public boolean func_71877_c(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        int xCord = x;
        int yCord = y;
        int zCord = z;
        switch (side) {
            case 0: {
                ++yCord;
                break;
            }
            case 1: {
                --yCord;
                break;
            }
            case 2: {
                ++zCord;
                break;
            }
            case 3: {
                --zCord;
                break;
            }
            case 4: {
                ++xCord;
                break;
            }
            case 5: {
                --xCord;
            }
        }
        if (this.field_71990_ca == iblockaccess.func_72798_a(x, y, z) && iblockaccess.func_72805_g(x, y, z) == iblockaccess.func_72805_g(xCord, yCord, zCord)) {
            return false;
        }
        return super.func_71877_c(iblockaccess, x, y, z, side);
    }

    public Icon func_71895_b(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        int metadata = iblockaccess.func_72805_g(i, j, k);
        if (metadata == ForceFieldTyps.Default.ordinal()) {
            return this.icons[0];
        }
        if (metadata == ForceFieldTyps.Zapper.ordinal()) {
            return this.icons[1];
        }
        if (metadata == ForceFieldTyps.Area.ordinal()) {
            return this.icons[2];
        }
        if (metadata == ForceFieldTyps.Containment.ordinal()) {
            return this.icons[3];
        }
        return this.icons[0];
    }

    public float getExplosionResistance(Entity entity, World world, int i, int j, int k, double d, double d1, double d2) {
        TileEntity tileEntity;
        ForceFieldBlockStack ffworldmap = WorldMap.getForceFieldWorld(world).getForceFieldStackMap(new PointXYZ(i, j, k, world).hashCode());
        if (ffworldmap != null && !ffworldmap.isEmpty() && (tileEntity = (TileEntity)Linkgrid.getWorldMap(world).getProjektor().get(ffworldmap.getProjectorID())) instanceof TileEntityProjector && tileEntity != null) {
            ((TileEntityProjector)tileEntity).consumePower(ModularForceFieldSystem.forceFieldBlockCost * ModularForceFieldSystem.forceFieldBlockCreateModifier, false);
        }
        return 999.0f;
    }

    public void func_71862_a(World world, int i, int j, int k, Random random) {
        if (ModularForceFieldSystem.showZapperParticles && world.func_72805_g(i, j, k) == ForceFieldTyps.Zapper.ordinal()) {
            double d = (double)i + Math.random() + 0.2;
            double d1 = (double)j + Math.random() + 0.2;
            double d2 = (double)k + Math.random() + 0.2;
            world.func_72869_a("townaura", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean canConnectRedstone(IBlockAccess iba, int i, int j, int k, int dir) {
        return false;
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        TileEntityProjector Projector;
        ForceFieldBlockStack ffworldmap = WorldMap.getForceFieldWorld(world).getForceFieldStackMap(new PointXYZ(x, y, z, world).hashCode());
        if (ffworldmap != null && !ffworldmap.isEmpty() && (Projector = (TileEntityProjector)Linkgrid.getWorldMap(world).getProjektor().get(ffworldmap.getProjectorID())) != null && !Projector.isActive()) {
            ffworldmap.removebyProjector(ffworldmap.getProjectorID());
        }
        if (ffworldmap == null || ffworldmap.isEmpty()) {
            world.func_72932_q(x, y, z);
            world.func_72832_d(x, y, z, 0, 0, 2);
        }
    }

    public TileEntity createTileEntity(World world, int meta) {
        if (meta == ForceFieldTyps.Camouflage.ordinal()) {
            return new TileEntityForceField();
        }
        return null;
    }

    public TileEntity func_72274_a(World world) {
        return this.createTileEntity(world, 0);
    }

    @Override
    public void weakenForceField(World world, int x, int y, int z) {
        if (ModularForceFieldSystem.influencedByOtherMods) {
            world.func_72832_d(x, y, z, 0, 0, 2);
        }
    }
}

