/*
 * Decompiled with CFR 0.152.
 */
package mods.mffs.common.block;

import buildcraft.api.tools.IToolWrench;
import java.util.Random;
import mods.mffs.common.ModularForceFieldSystem;
import mods.mffs.common.SecurityHelper;
import mods.mffs.common.SecurityRight;
import mods.mffs.common.item.ItemCardEmpty;
import mods.mffs.common.item.ItemCardPowerLink;
import mods.mffs.common.item.ItemCardSecurityLink;
import mods.mffs.common.modules.ModuleBase;
import mods.mffs.common.multitool.ItemMultitool;
import mods.mffs.common.tileentity.TileEntityAdvSecurityStation;
import mods.mffs.common.tileentity.TileEntityControlSystem;
import mods.mffs.common.tileentity.TileEntityMachines;
import mods.mffs.common.tileentity.TileEntityProjector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class BlockMFFSBase
extends BlockContainer {
    private int blockid;
    protected Icon[] icons = new Icon[4];

    public BlockMFFSBase(int i) {
        super(i, Material.field_76243_f);
        this.blockid = i;
        this.func_71875_q();
        this.func_71894_b(100.0f);
        this.func_71884_a(field_71977_i);
        this.func_71849_a(ModularForceFieldSystem.MFFSTab);
    }

    public abstract TileEntity func_72274_a(World var1);

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float par7, float par8, float par9) {
        Item equipped;
        if (entityplayer.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntityMachines tileentity = (TileEntityMachines)world.func_72796_p(x, y, z);
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped != null) {
            if (equipped instanceof ItemMultitool || equipped instanceof ItemCardEmpty || equipped instanceof ModuleBase || equipped instanceof ItemCardPowerLink || equipped instanceof ItemCardSecurityLink) {
                return false;
            }
            if (equipped.field_77779_bT == Block.field_72043_aJ.field_71990_ca) {
                return false;
            }
            if (tileentity == null) {
                return false;
            }
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, x, y, z)) {
                if (!tileentity.wrenchCanManipulate(entityplayer, side)) {
                    return false;
                }
                tileentity.setSide(side);
                ((IToolWrench)equipped).wrenchUsed(entityplayer, x, y, z);
                return true;
            }
        }
        if (tileentity instanceof TileEntityAdvSecurityStation && tileentity.isActive() && !SecurityHelper.isAccessGranted(tileentity, entityplayer, world, SecurityRight.CSR)) {
            return true;
        }
        if (tileentity instanceof TileEntityControlSystem && !SecurityHelper.isAccessGranted(tileentity, entityplayer, world, SecurityRight.UCS)) {
            return true;
        }
        if (!SecurityHelper.isAccessGranted(tileentity, entityplayer, world, SecurityRight.EB)) {
            return true;
        }
        entityplayer.openGui((Object)ModularForceFieldSystem.instance, 0, world, x, y, z);
        return true;
    }

    public void func_71852_a(World world, int i, int j, int k, int a, int b) {
        TileEntity tileEntity = world.func_72796_p(i, j, k);
        if (tileEntity instanceof TileEntityMachines) {
            ((TileEntityMachines)tileEntity).dropPlugins();
        }
        world.func_72932_q(i, j, k);
    }

    public int idDropped(int i, Random random) {
        return this.field_71990_ca;
    }

    public static boolean isActive(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity tileentity = iblockaccess.func_72796_p(i, j, k);
        if (tileentity instanceof TileEntityMachines) {
            return ((TileEntityMachines)tileentity).isActive();
        }
        return false;
    }

    public void func_71860_a(World world, int i, int j, int k, EntityLiving entityliving, ItemStack itemStack) {
        TileEntity tileEntity = world.func_72796_p(i, j, k);
        if (tileEntity instanceof TileEntityMachines) {
            int l = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int i1 = Math.round(entityliving.field_70125_A);
            if (i1 >= 65) {
                ((TileEntityMachines)tileEntity).setSide(1);
            } else if (i1 <= -65) {
                ((TileEntityMachines)tileEntity).setSide(0);
            } else if (l == 0) {
                ((TileEntityMachines)tileEntity).setSide(2);
            } else if (l == 1) {
                ((TileEntityMachines)tileEntity).setSide(5);
            } else if (l == 2) {
                ((TileEntityMachines)tileEntity).setSide(3);
            } else if (l == 3) {
                ((TileEntityMachines)tileEntity).setSide(4);
            }
        }
    }

    public Icon func_71895_b(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        int typ = 0;
        TileEntity tileentity = iblockaccess.func_72796_p(i, j, k);
        int facing = tileentity instanceof TileEntityMachines ? ((TileEntityMachines)tileentity).getSide() : 1;
        ForgeDirection blockfacing = ForgeDirection.getOrientation((int)l);
        ForgeDirection TileEntityfacing = ForgeDirection.getOrientation((int)facing);
        if (tileentity instanceof TileEntityProjector) {
            typ = ((TileEntityProjector)tileentity).getProjektor_Typ();
        }
        if (BlockMFFSBase.isActive(iblockaccess, i, j, k)) {
            if (blockfacing.equals((Object)TileEntityfacing)) {
                return this.icons[3];
            }
            return this.icons[2];
        }
        if (blockfacing.equals((Object)TileEntityfacing)) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public float getExplosionResistance(Entity entity, World world, int i, int j, int k, double d, double d1, double d2) {
        if (world.func_72796_p(i, j, k) instanceof TileEntityMachines) {
            TileEntity tileentity = world.func_72796_p(i, j, k);
            if (((TileEntityMachines)tileentity).isActive()) {
                return 999.0f;
            }
            return 100.0f;
        }
        return 100.0f;
    }
}

