/*
 * Decompiled with CFR 0.152.
 */
package mods.mffs.common;

import cpw.mods.fml.common.registry.LanguageRegistry;
import mods.mffs.common.Functions;
import mods.mffs.common.Linkgrid;
import mods.mffs.common.SecurityRight;
import mods.mffs.common.tileentity.TileEntityAdvSecurityStation;
import mods.mffs.common.tileentity.TileEntityAreaDefenseStation;
import mods.mffs.common.tileentity.TileEntityCapacitor;
import mods.mffs.common.tileentity.TileEntityControlSystem;
import mods.mffs.common.tileentity.TileEntityConverter;
import mods.mffs.common.tileentity.TileEntityExtractor;
import mods.mffs.common.tileentity.TileEntityProjector;
import mods.mffs.common.tileentity.TileEntitySecStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class SecurityHelper {
    public static boolean isAccessGranted(TileEntity tileEntity, EntityPlayer entityplayer, World world, SecurityRight right) {
        return SecurityHelper.isAccessGranted(tileEntity, entityplayer, world, right, false);
    }

    public static boolean isAccessGranted(TileEntity tileEntity, EntityPlayer entityplayer, World world, SecurityRight right, boolean suppresswarning) {
        if (tileEntity instanceof TileEntitySecStorage) {
            TileEntityAdvSecurityStation sec = ((TileEntitySecStorage)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                if (sec.isAccessGranted(entityplayer.field_71092_bJ, right)) {
                    return true;
                }
                if (!suppresswarning) {
                    entityplayer.func_70006_a(LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
                }
                return false;
            }
            return !world.field_72995_K;
        }
        if (tileEntity instanceof TileEntityControlSystem) {
            TileEntityAdvSecurityStation sec = ((TileEntityControlSystem)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                if (sec.isAccessGranted(entityplayer.field_71092_bJ, right)) {
                    return true;
                }
                if (!suppresswarning) {
                    entityplayer.func_70006_a(LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
                }
                return false;
            }
            return !world.field_72995_K;
        }
        if (tileEntity instanceof TileEntityAdvSecurityStation && !((TileEntityAdvSecurityStation)tileEntity).isAccessGranted(entityplayer.field_71092_bJ, right)) {
            if (!suppresswarning) {
                Functions.ChattoPlayer(entityplayer, LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
            }
            return false;
        }
        if (tileEntity instanceof TileEntityConverter) {
            TileEntityAdvSecurityStation sec = ((TileEntityConverter)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                if (sec.isAccessGranted(entityplayer.field_71092_bJ, right)) {
                    return true;
                }
                if (!suppresswarning) {
                    Functions.ChattoPlayer(entityplayer, LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
                }
                return false;
            }
            return true;
        }
        if (tileEntity instanceof TileEntityCapacitor) {
            TileEntityAdvSecurityStation sec = ((TileEntityCapacitor)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                if (sec.isAccessGranted(entityplayer.field_71092_bJ, right)) {
                    return true;
                }
                if (!suppresswarning) {
                    Functions.ChattoPlayer(entityplayer, LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
                }
                return false;
            }
            return true;
        }
        if (tileEntity instanceof TileEntityExtractor) {
            TileEntityAdvSecurityStation sec = ((TileEntityExtractor)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                if (sec.isAccessGranted(entityplayer.field_71092_bJ, right)) {
                    return true;
                }
                if (!suppresswarning) {
                    Functions.ChattoPlayer(entityplayer, LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
                }
                return false;
            }
            return true;
        }
        if (tileEntity instanceof TileEntityAreaDefenseStation) {
            TileEntityAdvSecurityStation sec = ((TileEntityAreaDefenseStation)tileEntity).getLinkedSecurityStation();
            if (sec != null) {
                if (sec.isAccessGranted(entityplayer.field_71092_bJ, right)) {
                    return true;
                }
                if (!suppresswarning) {
                    Functions.ChattoPlayer(entityplayer, LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
                }
                return false;
            }
            return true;
        }
        if (tileEntity instanceof TileEntityProjector) {
            switch (((TileEntityProjector)tileEntity).getaccesstyp()) {
                case 2: {
                    TileEntityAdvSecurityStation sec;
                    TileEntityCapacitor cap = (TileEntityCapacitor)Linkgrid.getWorldMap(world).getCapacitor().get(((TileEntityProjector)tileEntity).getPowerSourceID());
                    if (cap == null || (sec = cap.getLinkedSecurityStation()) == null) break;
                    if (sec.isAccessGranted(entityplayer.field_71092_bJ, right)) {
                        return true;
                    }
                    if (!suppresswarning) {
                        Functions.ChattoPlayer(entityplayer, LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
                    }
                    return false;
                }
                case 3: {
                    TileEntityAdvSecurityStation sec = ((TileEntityProjector)tileEntity).getLinkedSecurityStation();
                    if (sec == null) break;
                    if (sec.isAccessGranted(entityplayer.field_71092_bJ, right)) {
                        return true;
                    }
                    if (!suppresswarning) {
                        Functions.ChattoPlayer(entityplayer, LanguageRegistry.instance().getStringLocalization("fieldSecurity.accessDenied"));
                    }
                    return false;
                }
            }
            return true;
        }
        return true;
    }
}

