/*
 * Decompiled with CFR 0.152.
 */
package mods.mffs.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.mffs.api.IForceEnergyItems;
import mods.mffs.api.IPowerLinkItem;
import mods.mffs.common.NBTTagCompoundHelper;
import mods.mffs.common.item.ItemMFFSBase;
import mods.mffs.common.tileentity.TileEntityMachines;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemForcePowerCrystal
extends ItemMFFSBase
implements IPowerLinkItem,
IForceEnergyItems {
    private Icon[] damagedIcons = new Icon[5];

    public ItemForcePowerCrystal(int i) {
        super(i);
        this.func_77625_d(1);
        this.func_77656_e(100);
    }

    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("mffs:ForcePowerCrystal");
        for (int _i = 0; _i < 5; ++_i) {
            this.damagedIcons[_i] = iconRegister.func_94245_a("mffs:ForcePowerCrystal_" + _i);
        }
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_77645_m() {
        return true;
    }

    @Override
    public int getPowerTransferrate() {
        return 100000;
    }

    public Icon func_77617_a(int dmg) {
        if (dmg == 0) {
            return this.field_77791_bV;
        }
        return this.damagedIcons[(100 - dmg) / 20];
    }

    @Override
    public int getItemDamage(ItemStack itemStack) {
        return 101 - this.getAvailablePower(itemStack, null, null) * 100 / this.getMaximumPower(itemStack);
    }

    @Override
    public int getMaximumPower(ItemStack itemStack) {
        return 5000000;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        String tooltip = String.format("%d FE/%d FE ", this.getAvailablePower(itemStack, null, null), this.getMaximumPower(itemStack));
        info.add(tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int i, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        charged.func_77964_b(1);
        this.setAvailablePower(charged, this.getMaximumPower(null));
        itemList.add(charged);
        ItemStack empty = new ItemStack((Item)this, 1);
        empty.func_77964_b(100);
        this.setAvailablePower(empty, 0);
        itemList.add(empty);
    }

    @Override
    public boolean isPowersourceItem() {
        return true;
    }

    @Override
    public int getAvailablePower(ItemStack itemStack, TileEntityMachines tem, World world) {
        NBTTagCompound nbtTagCompound = NBTTagCompoundHelper.getTAGfromItemstack(itemStack);
        if (nbtTagCompound != null) {
            return nbtTagCompound.func_74762_e("ForceEnergy");
        }
        return 0;
    }

    @Override
    public int getMaximumPower(ItemStack itemStack, TileEntityMachines tem, World world) {
        return this.getMaximumPower(itemStack);
    }

    @Override
    public boolean consumePower(ItemStack itemStack, int powerAmount, boolean simulation, TileEntityMachines tem, World world) {
        if (this.getAvailablePower(itemStack, null, null) >= powerAmount) {
            if (!simulation) {
                this.setAvailablePower(itemStack, this.getAvailablePower(itemStack, null, null) - powerAmount);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getPowersourceID(ItemStack itemStack, TileEntityMachines tem, World world) {
        return -1;
    }

    @Override
    public int getPercentageCapacity(ItemStack itemStack, TileEntityMachines tem, World world) {
        return this.getAvailablePower(itemStack, null, null) / 1000 * 100 / (this.getMaximumPower(itemStack) / 1000);
    }

    @Override
    public boolean insertPower(ItemStack itemStack, int powerAmount, boolean simulation, TileEntityMachines tem, World world) {
        if (this.getAvailablePower(itemStack) + powerAmount <= this.getMaximumPower(itemStack)) {
            if (!simulation) {
                this.setAvailablePower(itemStack, this.getAvailablePower(itemStack, null, null) + powerAmount);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getfreeStorageAmount(ItemStack itemStack, TileEntityMachines tem, World world) {
        return this.getMaximumPower(itemStack) - this.getAvailablePower(itemStack, null, null);
    }

    @Override
    public void setAvailablePower(ItemStack itemStack, int ForceEnergy) {
        NBTTagCompound nbtTagCompound = NBTTagCompoundHelper.getTAGfromItemstack(itemStack);
        nbtTagCompound.func_74768_a("ForceEnergy", ForceEnergy);
        itemStack.func_77964_b(this.getItemDamage(itemStack));
    }

    @Override
    public int getAvailablePower(ItemStack itemStack) {
        return this.getAvailablePower(itemStack, null, null);
    }

    @Override
    public boolean consumePower(ItemStack itemStack, int powerAmount, boolean simulation) {
        return this.consumePower(itemStack, powerAmount, simulation, null, null);
    }
}

