package mods.ElectricRails;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class BlockMaglevRail extends BlockContainer
{
    protected String iconName;

    // blockIcon - top and bottom textures
    @SideOnly(Side.CLIENT)
    protected Icon sideEmpty; // texture without magnet
    @SideOnly(Side.CLIENT)
    protected Icon sideRail; // texture with magnet

    public BlockMaglevRail(int id, Material material, String iconName)
    {
        super(id, material);
        setBlockBounds(0.0F, 0.0F, 0.0F, 1.0F, 0.5F, 1.0F);
        this.iconName = iconName;
    }

    @Override
    public boolean isOpaqueCube()
    {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock()
    {
        return false;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public Icon getIcon(int side, int metadata)
    {
        /**
         * Sides:
         * 0 - bottom (-y)
         * 1 - top (+y)
         * 2 - north (-z)
         * 3 - south (+z)
         * 4 - west (-x)
         * 5 - east (+x)
         */
        if (side == 0 || side == 1) return blockIcon;

        // Display sides depending on metadata mask
        if ( (metadata & 1 << side - 2) == 0 ) return sideRail;
        return sideEmpty;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister iconRegister)
    {
        blockIcon = iconRegister.registerIcon(iconName);
        sideEmpty = iconRegister.registerIcon(iconName + "_side");
        sideRail  = iconRegister.registerIcon(iconName + "_side_magnet");
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int neighborID)
    {
        onBlockAdded(world, x, y, z);
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z)
    {
        if (world.isRemote) return;

        // Update metadata depending on adjacent rails (inverted for inventory display purpose)
        int metadata = 15;
        if (isMaglevCover(world, x, y, z-1)) metadata &= -2; // z- => north
        if (isMaglevCover(world, x, y, z+1)) metadata &= -3; // z+ => south
        if (isMaglevCover(world, x-1, y, z)) metadata &= -5; // x- => west
        if (isMaglevCover(world, x+1, y, z)) metadata &= -9; // x+ => east
        world.setBlockMetadataWithNotify(x, y, z, metadata, 3);
    }

    public boolean isMaglevCover(World world, int x, int y, int z)
    {
        TileEntity tile = world.getBlockTileEntity(x, y, z);
        return BlockRailBase.isRailBlockAt(world, x, y, z) && tile != null && tile instanceof TileEntityMaglevCover;
    }

    @Override
    public TileEntity createNewTileEntity(World world)
    {
        return new TileEntityMaglevRail();
    }
}
