package mods.ElectricRails;

import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class EntitySparksFX extends EntityFX
{

    public EntitySparksFX(World par1World, double par2, double par4, double par6)
    {
        super(par1World, par2, par4, par6);
        particleGravity = Block.blockSnow.blockParticleGravity;
        particleMaxAge *= 4;
    }

    public EntitySparksFX(World par1World, double par2, double par4, double par6, double par8, double par10, double par12)
    {
        super(par1World, par2, par4, par6, par8, par10, par12);
        particleGravity = Block.blockSnow.blockParticleGravity;
        particleMaxAge *= 3;
    }

    // Clamp
    public float clamp(float y)
    {
        if (y < 0.0F) return 0.0F;
        if (y > 1.0F) return 1.0F;
        return y;
    }

    // Linear kernel
    public float linear(float x, float startX, float endX)
    {
        float y = (x - startX) / (endX - startX);
        return clamp(y);
    }

    // Handy gaussian kernel
    public float gauss(float x)
    {
        double d = x * Math.E;
        return (float) Math.exp(- d * d);
    }

    // This is really cool function!... probably
    public float cool(float x, float start, float end)
    {
        return clamp(gauss(1.0F - linear(x, start, end)));
    }

    @Override
    public void renderParticle(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7)
    {
        float f6 = this.particleTextureIndexX / 16.0F;
        float f7 = f6 + 0.0624375F;
        float f8 = this.particleTextureIndexY / 16.0F;
        float f9 = f8 + 0.0624375F;
        float f10 = 0.1F * this.particleScale;

        if (this.particleIcon != null)
        {
            f6 = this.particleIcon.getMinU();
            f7 = this.particleIcon.getMaxU();
            f8 = this.particleIcon.getMinV();
            f9 = this.particleIcon.getMaxV();
        }

        float f11 = (float)(this.prevPosX + (this.posX - this.prevPosX) * par2 - interpPosX);
        float f12 = (float)(this.prevPosY + (this.posY - this.prevPosY) * par2 - interpPosY);
        float f13 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * par2 - interpPosZ);

        // Thermal color transition

        float stage = 1.0F - (float) particleAge / (float) particleMaxAge;

        // inverted gradient:
        // red -> yellow -> white
        // transparent --> opaque
        float red   = cool(stage, 0.000F, 1.0F / 3.0F);
        float green = cool(stage, 0.000F, 2.0F / 3.0F);
        float blue  = cool(stage, 0.000F, 1.000F);
        float alpha = red;

        // Render

        par1Tessellator.setColorRGBA_F(red, green, blue, alpha);
        par1Tessellator.addVertexWithUV(f11 - par3 * f10 - par6 * f10, f12 - par4 * f10, f13 - par5 * f10 - par7 * f10, f7, f9);
        par1Tessellator.addVertexWithUV(f11 - par3 * f10 + par6 * f10, f12 + par4 * f10, f13 - par5 * f10 + par7 * f10, f7, f8);
        par1Tessellator.addVertexWithUV(f11 + par3 * f10 + par6 * f10, f12 + par4 * f10, f13 + par5 * f10 + par7 * f10, f6, f8);
        par1Tessellator.addVertexWithUV(f11 + par3 * f10 - par6 * f10, f12 - par4 * f10, f13 + par5 * f10 - par7 * f10, f6, f9);
    }

    @Override
    public float getBrightness(float par1)
    {
        float a = (float) particleAge / (float) particleMaxAge;
        return clamp(super.getBrightness(par1) * a + 1.0F - a);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public int getBrightnessForRender(float par1)
    {
        int l = super.getBrightnessForRender(par1);
        int j = l & 255;
        int k = l >> 16 & 255;

        float a = (float) particleAge / (float) particleMaxAge;
        j = (int) (j * a + 240 * (1.0F - a));
        k = (int) (k * a + 240 * (1.0F - a));
        if (j < 0) j = 0;
        if (j > 240) j = 240;
        if (k < 0) k = 0;
        if (k > 240) k = 240;
        return j | k << 16;
    }
}
