package mods.ElectricRails;

import net.minecraft.block.ITileEntityProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockMaglevCover extends BlockRailAdvanced implements ITileEntityProvider
{
    public BlockMaglevCover(int id, String iconName, float speedAmplifier)
    {
        super(id, iconName, speedAmplifier);
    }

    @Override
    public boolean hasTileEntity(int metadata)
    {
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World world)
    {
        return new TileEntityMaglevCover();
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int neighborID)
    {
        super.onNeighborBlockChange(world, x, y, z, neighborID);

        // When neighbor block is changed, cover should update it's linked rails, e.g. reset linked rails and force to find rails again
        if (world.isRemote) return;
        TileEntity tile = world.getBlockTileEntity(x, y, z);
        if (tile != null && tile instanceof TileEntityMaglevCover)
        {
            ((TileEntityMaglevCover) tile).updateRails(true);
        }
    }
}
