package mods.ElectricRails;

import ic2.api.Direction;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.NetworkHelper;

import java.util.Arrays;
import java.util.List;

/**
 * Extended energy sink - will automatically synchronize 'energy' field to client side. Use {@link #updateEntity2()} method.
 */
public abstract class TileEntityNetworkedSink extends TileEntitySink implements INetworkDataProvider
{
    public static final List<String> networkedFields = Arrays.asList(new String[] {"energy"});
    public boolean initialized = false;

    @Override
    public void updateEntity()
    {
        // Request initial data for client
        if (initialized == false)
        {
            NetworkHelper.requestInitialData(this);
            initialized = true;
        }

        // Add to EnergyNet
        super.updateEntity();

        // Flag to detect updates for "energy" field
        int energyBefore = energy;

        updateEntity2();

        // Synchronize energy if it changed
        if (energy != energyBefore) NetworkHelper.updateTileEntityField(this, "energy");
    }

    public abstract void updateEntity2();

    @Override
    public int injectEnergy(Direction directionFrom, int amount)
    {
        if (!initialized) return amount;
        int ret = super.injectEnergy(directionFrom, amount);
        if (amount <= getMaxSafeInput())
        {
            NetworkHelper.updateTileEntityField(this, "energy");
        }
        return ret;
    }

    @Override
    public abstract int getMaxSafeInput();

    @Override
    public List<String> getNetworkedFields()
    {
        return networkedFields;
    }
}
