package mods.ElectricRails;

import net.minecraft.block.BlockRail;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class BlockRailAdvanced extends BlockRail
{
    protected String iconName;
    protected float speedAmplifier = 1.0F;
    @SideOnly(Side.CLIENT)
    protected Icon turnIcon;

    public BlockRailAdvanced(int id, String iconName, float speedAmplifier)
    {
        super(id);
        this.iconName = iconName;
        this.speedAmplifier = speedAmplifier;
    }

    @Override
    public float getRailMaxSpeed(World world, EntityMinecart cart, int y, int x, int z)
    {
        return super.getRailMaxSpeed(world, cart, y, x, z) * speedAmplifier;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister iconRegister)
    {
        blockIcon = iconRegister.registerIcon(iconName);
        turnIcon  = iconRegister.registerIcon(iconName + "_turn");
    }

    @Override
    @SideOnly(Side.CLIENT)
    public Icon getIcon(int side, int metadata)
    {
        return metadata >= 6 ? turnIcon : blockIcon;
    }
}
