package mods.ElectricRails;

import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.tileentity.TileEntity;

/**
 * Utility tile entity class, to add boost abilities to all others
 */
public abstract class TileEntityBase extends TileEntity
{
    // Boost cart, taken from EntityMinecart, same as for powered rails
    public boolean boostCart(EntityMinecart cart)
    {
        int metadata = worldObj.getBlockMetadata(xCoord, yCoord, zCoord);
        double d15 = Math.sqrt(cart.motionX * cart.motionX + cart.motionZ * cart.motionZ);

        if (d15 > 0.01D)
        {
            double d16 = 0.06D;
            cart.motionX += cart.motionX / d15 * d16;
            cart.motionZ += cart.motionZ / d15 * d16;
            return true;
        }
        else if (metadata == 1)
        {
            if (worldObj.isBlockNormalCube(xCoord - 1, yCoord, zCoord))
            {
                cart.motionX = 0.02D;
                return true;
            }
            else if (worldObj.isBlockNormalCube(xCoord + 1, yCoord, zCoord))
            {
                cart.motionX = -0.02D;
                return true;
            }
        }
        else if (metadata == 0)
        {
            if (worldObj.isBlockNormalCube(xCoord, yCoord, zCoord - 1))
            {
                cart.motionZ = 0.02D;
                return true;
            }
            else if (worldObj.isBlockNormalCube(xCoord, yCoord, zCoord + 1))
            {
                cart.motionZ = -0.02D;
                return true;
            }
        }
        return false;
    }
}
