package mods.ElectricRails;

import ic2.api.Direction;
import ic2.api.energy.tile.IEnergyConductor;

import java.util.List;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class TileEntityElectricRail extends TileEntityNetworkedSink implements IEnergyConductor
{
    @Override
    public ItemStack getCarrier()
    {
        int bid = worldObj.getBlockId(xCoord, yCoord, zCoord);
        if (bid == ElectricRails.instance.standardElectricTrackID)
            return ElectricRails.instance.stackStandardTrack;
        else if (bid == ElectricRails.instance.advancedElectricTrackID)
            return ElectricRails.instance.stackAdvancedTrack;
        else
            return null;
    }

    @SideOnly(Side.CLIENT)
    public void doSparks(double sparksX, double sparksZ, boolean randomizeRail)
    {
        // Get rail orientation
        int meta = worldObj.getBlockMetadata(xCoord, yCoord, zCoord);

        // Bind sparks to rails
        double x = sparksX - xCoord;
        double y = 0.0D;
        double z = sparksZ - zCoord;
        double d1 = 3.25D / 16.0D;
        double d2 = 1.0D - d1;

        if (meta == 0 || meta == 4 || meta == 5) // Motion by Z axis
        {
            if (randomizeRail) x = x + rand.nextGaussian() * 2.0D - 1.0D;
            x = (x > 0.5) ? d2 : d1;
            if (z <= 0.0D) z = 0.0D;
            if (z >= 1.0D) z = 1.0D;
            if (meta == 4) y = z;
            if (meta == 5) y = 1.0D - z;
        }
        else if (meta == 1 || meta == 2 || meta == 3) // Motion by X axis
        {
            if (randomizeRail) z = z + rand.nextGaussian() * 2.0D - 1.0D;
            if (x <= 0.0D) x = 0.0D;
            if (x >= 1.0D) x = 1.0D;
            z = (z > 0.5) ? d2 : d1;
            if (meta == 2) y = x;
            if (meta == 3) y = 1.0D - x;
        }
        else if (meta == 6 || meta == 7 || meta == 8 || meta == 9)
        {
            double anchorX = 0.0;
            double anchorZ = 0.0;

            if (meta == 6) // 0x6: WestNorth corner (connecting East and South)
            {
                anchorX = 1.0;
                anchorZ = 1.0;
            }
            else if (meta == 7) // 0x7: EastNorth corner (connecting West and South)
            {
                anchorX = 0.0;
                anchorZ = 1.0;
            }
            else if (meta == 8) // 0x8: EastSouth corner (connecting West and North)
            {
                anchorX = 0.0;
                anchorZ = 0.0;
            }
            else if (meta == 9) // 0x9: WestSouth corner (connecting East and North)
            {
                anchorX = 1.0;
                anchorZ = 0.0;
            }

            if (x <= 0.0D) x = 0.0D;
            if (x >= 1.0D) x = 1.0D;
            if (z <= 0.0D) z = 0.0D;
            if (z >= 1.0D) z = 1.0D;

            // Rotate
            x = anchorX - x;
            z = anchorZ - z;

            // Get length from entity to corner
            double l = Math.sqrt(x * x + z * z);

            // Randomize if needed
            if (randomizeRail) l = l + rand.nextGaussian() * 2.0 - 1.0;

            // Bind it to rail
            l = (l > 0.5) ? d2 : d1;

            // Calculate angle
            double angle = Math.atan2(z, x);

            // Calculate binded coords and rotate back
            x = anchorX - Math.cos(angle) * l;
            z = anchorZ - Math.sin(angle) * l;
        }

        // Spawn particles in the world
        super.doSparks(x + xCoord, y + yCoord, z + zCoord);
    }

    @Override
    public void updateEntity2()
    {
        // Flag to determine whether rails are generated sparks this tick
        boolean sparks = false;

        if (energy == 0) return;

        // Get sensitive AABB
        final double f = 0.125F;
        AxisAlignedBB aabb = AxisAlignedBB.getAABBPool().getAABB(xCoord + f, yCoord, zCoord + f, xCoord + 1.0D - f, yCoord + 0.25D, zCoord + 1.0D - f);
        List<?> list = worldObj.getEntitiesWithinAABBExcludingEntity(null, aabb);
        if (list != null && !list.isEmpty())
        {
            for (Object obj : list)
            {
                if (obj == null) continue;
                if (obj instanceof EntityMinecart)
                {
                    // if legacy mode, then boost usual carts
                    EntityMinecart cart = (EntityMinecart) obj;
                    if (canConsume(ElectricRails.instance.electricTracksEU) && boostCart(cart))
                    {
                        consumeEnergy(ElectricRails.instance.electricTracksEU);
                        if (worldObj.isRemote && rand.nextDouble() < 0.01D)
                        {
                            doSparks(cart.posX, cart.posZ, true);
                            sparks = true;
                        }
                        if (energy == 0)
                        {
                            list.clear();
                            return;
                        }
                    }
                }
                else if (obj instanceof EntityLiving && worldObj.getWorldTime() % 20 == 0)
                {
                    EntityLiving living = (EntityLiving) obj;

                    // Find last riding entity
                    Entity riding = living;
                    while (riding.ridingEntity != null) riding = riding.ridingEntity;

                    // Skip living if it riding a cart
                    if (riding instanceof EntityMinecart) continue;

                    // Otherwise generate sparks and hurt it
                    if (worldObj.isRemote)
                    {
                        doSparks(living.posX, living.posZ, false);
                        sparks = true;
                    }
                    living.attackEntityFrom(ElectricRails.electricity, living.isWet() ? 4 : 2);
                    energy = 0;
                    consumed = 0;
                    list.clear();
                    return;
                }
            }
            list.clear();
        }

        // Do random sparks from rails when no carts and no livings
        if (worldObj.isRemote && sparks == false && energy > 0 && rand.nextDouble() < 0.000075D)
        {
            doSparks(xCoord + rand.nextGaussian(), zCoord + rand.nextGaussian(), false);
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction)
    {
        return emitter != this && emitter instanceof TileEntityElectricRail || direction == Direction.YN;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction)
    {
        return receiver != this && receiver instanceof TileEntityElectricRail || direction == Direction.YN;
    }

    @Override
    public int getMaxSafeInput()
    {
        return 2048;
    }

    @Override
    public double getConductionLoss()
    {
        return 1.0;
    }

    @Override
    public int getInsulationEnergyAbsorption()
    {
        return 9001;
    }

    @Override
    public int getInsulationBreakdownEnergy()
    {
        return 9001;
    }

    @Override
    public int getConductorBreakdownEnergy()
    {
        return getMaxSafeInput() + 1;
    }

    @Override
    public void removeInsulation()
    {
        // No insulation
    }

    @Override
    public void removeConductor()
    {
        onOvervoltage();
    }
}
