package mods.ElectricRails;

import ic2.api.item.Items;
import ic2.api.recipe.Recipes;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;

@Mod(modid = "ElectricRails", name = "ElectricRails", version = "0.02.1", dependencies = "required-after:IC2; after:Railcraft")
@NetworkMod(clientSideRequired = true, serverSideRequired = true)
public class ElectricRails
{
    // The instance of mod that Forge uses.
    @Instance("ElectricRails")
    public static ElectricRails instance = null;

    // Const
    public static final String ICON_BASE = "ElectricRails:";
    public static final String RAILCRAFT = "Railcraft"; // RailCraft ModID (case sensitive)
    public static final DamageSourceElectricity electricity = new DamageSourceElectricity();

    // Config variables
    public int electricRailID = 29899;

    public int standardElectricTrackID = 781;
    public int advancedElectricTrackID = 782;
    public int thirdRailID             = 783;
    public int advancedTrackID         = 784;
    public int maglevRailID            = 785;
    public int maglevCoverID           = 786;

    public double electricTracksEU = 1.0D; // EU/t
    public double thirdRailEU      = 1.0D;
    public double maglevRailEU     = 0.1D;

    public double advancedSpeed    = 1.25; // xN
    public double maglevSpeed      = 3.0D; // xN

    // Items/Blocks
    public ItemGeneric itemElectricRail = null;
    public BlockRailElectric blockStandardElectricTrack = null;
    public BlockRailElectric blockAdvancedElectricTrack = null;
    public BlockRailThird blockThirdRail = null;

    public BlockRailAdvanced blockAdvancedTrack = null;

    public BlockMaglevRail blockMaglevRail = null;
    public BlockMaglevCover blockMaglevCover = null;

    // Common stuff
    public ItemStack stackStoneSlab = new ItemStack(Block.stoneSingleSlab);
    public ItemStack stackStandardTrack = new ItemStack(Block.rail);
    public ItemStack stackAdvancedTrack = null;

    @PreInit
    public void preInit(FMLPreInitializationEvent event)
    {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try
        {
            config.load();

            config.addCustomCategoryComment("Items", "Items IDs");

            electricRailID = config.get("Items", "ElectricRailID", electricRailID).getInt(electricRailID);

            config.addCustomCategoryComment("Blocks", "Blocks IDs");

            standardElectricTrackID = config.getBlock("Blocks", "StandardElectricTrackID", standardElectricTrackID).getInt(standardElectricTrackID);
            advancedElectricTrackID = config.getBlock("Blocks", "AdvancedElectricTrackID", advancedElectricTrackID).getInt(advancedElectricTrackID);
            thirdRailID             = config.getBlock("Blocks", "ThirdRailID", thirdRailID).getInt(thirdRailID);
            advancedTrackID         = config.getBlock("Blocks", "AdvancedTrackID", advancedTrackID).getInt(advancedTrackID);
            maglevRailID            = config.getBlock("Blocks", "MaglevRailID", maglevRailID).getInt(maglevRailID);
            maglevCoverID           = config.getBlock("Blocks", "MaglevCoverID", maglevCoverID).getInt(maglevCoverID);

            config.addCustomCategoryComment("Energy", "Energy consumption rates when boosting cart (EU/t)");

            electricTracksEU = config.get("Energy", "ElectricTracksEU", electricTracksEU).getDouble(electricTracksEU);
            thirdRailEU      = config.get("Energy", "ThirdRailEU", thirdRailEU).getDouble(thirdRailEU);
            maglevRailEU     = config.get("Energy", "MaglevRailEU", maglevRailEU, "Amount of EU/t to consume per magnet rail block, e.g. it will be doubled in total but each part will be drained from different magnets.").getDouble(maglevRailEU);

            config.addCustomCategoryComment("Speed", "Max speed factors of tracks relative to standard tracks (1.0).");

            advancedSpeed    = config.get("Speed", "AdvancedTracksSpeed", advancedSpeed).getDouble(advancedSpeed);
            maglevSpeed      = config.get("Speed", "MaglevSpeed", maglevSpeed).getDouble(maglevSpeed);
        }
        finally
        {
            if (config.hasChanged()) config.save();
        }
    }

    @Init
    public void load(FMLInitializationEvent event)
    {
        boolean client = event.getSide() == Side.CLIENT;

        // Electric Rail (item)

        itemElectricRail = new ItemGeneric(electricRailID - 256, ICON_BASE + "electric_rail");
        itemElectricRail.setUnlocalizedName("railElectric");
        itemElectricRail.setMaxDamage(0);
        itemElectricRail.setNoRepair();
        LanguageRegistry.addName(itemElectricRail, "Electric Rail");
        if (client) itemElectricRail.setCreativeTab(CreativeTabs.tabTransport);
        GameRegistry.registerItem(itemElectricRail, "electricRail");

        // Standard Track

        blockStandardElectricTrack = new BlockRailElectric(standardElectricTrackID, ICON_BASE + "standard_electric_track", 1.0F);
        blockStandardElectricTrack.setHardness(0.7F);
        blockStandardElectricTrack.setStepSound(Block.soundMetalFootstep);
        blockStandardElectricTrack.setUnlocalizedName("trackElectric");
        LanguageRegistry.addName(blockStandardElectricTrack, "Electric Track");
        if (client) blockStandardElectricTrack.setCreativeTab(CreativeTabs.tabTransport);
        GameRegistry.registerBlock(blockStandardElectricTrack, "standardElectricTrack");

        // Advanced Track (non-electric)

        blockAdvancedTrack = new BlockRailAdvanced(advancedTrackID, ICON_BASE + "advanced_track", 1.25F);
        blockAdvancedTrack.setHardness(0.7F);
        blockAdvancedTrack.setStepSound(Block.soundMetalFootstep);
        blockAdvancedTrack.setUnlocalizedName("trackAdvanced");
        LanguageRegistry.addName(blockAdvancedTrack, "Advanced Track");
        if (client) blockAdvancedTrack.setCreativeTab(CreativeTabs.tabTransport);
        GameRegistry.registerBlock(blockAdvancedTrack, "advancedTrack");

        stackAdvancedTrack = new ItemStack(blockAdvancedTrack, 1);

        // Advanced Electric Track

        blockAdvancedElectricTrack = new BlockRailElectric(advancedElectricTrackID, ICON_BASE + "advanced_electric_track", 1.25F);
        blockAdvancedElectricTrack.setHardness(0.7F);
        blockAdvancedElectricTrack.setStepSound(Block.soundMetalFootstep);
        blockAdvancedElectricTrack.setUnlocalizedName("trackAdvancedElectric");
        LanguageRegistry.addName(blockAdvancedElectricTrack, "Advanced Electric Track");
        if (client) blockAdvancedElectricTrack.setCreativeTab(CreativeTabs.tabTransport);
        GameRegistry.registerBlock(blockAdvancedElectricTrack, "advancedElectricTrack");

        // "Third Rail"

        blockThirdRail = new BlockRailThird(thirdRailID, Material.rock, ICON_BASE + "third_rail");
        blockThirdRail.setHardness(0.7F);
        blockThirdRail.setStepSound(Block.soundStoneFootstep);
        blockThirdRail.setUnlocalizedName("thirdRail");
        LanguageRegistry.addName(blockThirdRail, "Third Rail");
        if (client) blockThirdRail.setCreativeTab(CreativeTabs.tabTransport);
        GameRegistry.registerBlock(blockThirdRail, "thirdRail");

        // Maglev Rail (magnet block)

        blockMaglevRail = new BlockMaglevRail(maglevRailID, Material.rock, ICON_BASE + "maglev_rail");
        blockMaglevRail.setHardness(0.7F);
        blockMaglevRail.setStepSound(Block.soundStoneFootstep);
        blockMaglevRail.setUnlocalizedName("maglevRail");
        LanguageRegistry.addName(blockMaglevRail, "Maglev Rail");
        if (client) blockMaglevRail.setCreativeTab(CreativeTabs.tabTransport);
        GameRegistry.registerBlock(blockMaglevRail, "maglevRail");

        // Maglev Cover (physical rail)

        blockMaglevCover = new BlockMaglevCover(maglevCoverID, ICON_BASE + "maglev_cover", (float) maglevSpeed);
        blockMaglevCover.setHardness(0.7F);
        blockMaglevCover.setStepSound(Block.soundStoneFootstep);
        blockMaglevCover.setUnlocalizedName("maglevCover");
        LanguageRegistry.addName(blockMaglevCover, "Maglev Cover");
        if (client) blockMaglevCover.setCreativeTab(CreativeTabs.tabTransport);
        GameRegistry.registerBlock(blockMaglevCover, "maglevCover");

        GameRegistry.registerTileEntity(TileEntityElectricRail.class, "TileEntityElectricRail");

        GameRegistry.registerTileEntity(TileEntityThirdRail.class, "TileEntityThirdRail");

        GameRegistry.registerTileEntity(TileEntityMaglevCover.class, "TileEntityMaglevCover");
        GameRegistry.registerTileEntity(TileEntityMaglevRail.class, "TileEntityMaglevRail");

        LanguageRegistry.instance().addStringLocalization("death.attack.electricity", "%1$s was electrocuted");
    }

    @PostInit
    public void postInit(FMLPostInitializationEvent event)
    {
        //dropTagList();

        ItemStack stackLazurite    = new ItemStack(Item.dyePowder, 1, 4);
        ItemStack stackCopperCable = Items.getItem("insulatedCopperCableItem");
        ItemStack stackIronCable   = Items.getItem("ironCableItem");
        ItemStack stackRefinedIronIngot = Items.getItem("refinedIronIngot");

        ItemStack stackStandardRail  = GameRegistry.findItemStack(RAILCRAFT, "part.rail.standard", 1);
        ItemStack stackWoodenRailbed = GameRegistry.findItemStack(RAILCRAFT, "part.railbed.wood", 1);
        ItemStack stackStoneRailbed  = GameRegistry.findItemStack(RAILCRAFT, "part.railbed.stone", 1);

        // All Railcraft based recipes require that standard rails be available
        boolean isRailCraft = Loader.isModLoaded(RAILCRAFT) && stackStandardRail != null;

        // Electric Rail (RailCraft only)

        ItemStack stackElectricRail = new ItemStack(itemElectricRail);

        if (isRailCraft)
        {
            Recipes.advRecipes.addShapelessRecipe(
                    stackElectricRail,
                    new Object[] {
                        stackStandardRail,
                        stackIronCable
                        });
        }

        // Standard Electric Track

        if (isRailCraft && stackWoodenRailbed != null)
        {
            // RailCraft recipe that uses electric rails
            Recipes.advRecipes.addRecipe(
                    new ItemStack(blockStandardElectricTrack, 16),
                    new Object[] {
                        "R R", "RBR", "R R",
                        'R', stackElectricRail,
                        'B', stackWoodenRailbed
                        });
        }

        // Upgrade/crafting recipe for standard rails for both RailCraft and vanilla
        Recipes.advRecipes.addShapelessRecipe(
                new ItemStack(blockStandardElectricTrack, 1),
                new Object[] {
                    new ItemStack(Block.rail),
                    stackIronCable
                    });

        // Advanced Track

        if (isRailCraft && stackStoneRailbed != null)
        {
            // RailCraft
            Recipes.advRecipes.addRecipe(
                    new ItemStack(blockAdvancedTrack, 16),
                    new Object[] {
                        "R R", "RBR", "R R",
                        'R', stackStandardRail,
                        'B', stackStoneRailbed
                        });
        }
        else
        {
            // Vanilla
            Recipes.advRecipes.addRecipe(
                    new ItemStack(blockAdvancedTrack, 16),
                    new Object[] {
                        "ISI", "ISI", "ISI",
                        'I', new ItemStack(Item.ingotIron),
                        'S', stackStoneSlab
                        });
        }

        // Advanced Electric Track Recipe

        if (isRailCraft && stackStoneRailbed != null)
        {
            // RailCraft
            Recipes.advRecipes.addRecipe(
                    new ItemStack(blockAdvancedElectricTrack, 16),
                    new Object[] {
                        "R R", "RBR", "R R",
                        'R', stackElectricRail,
                        'B', stackStoneRailbed
                        });
        }
        else
        {
            // Vanilla
            Recipes.advRecipes.addRecipe(
                    new ItemStack(blockAdvancedElectricTrack, 8),
                    new Object[] {
                        "ISI", "ISI", "ISI",
                        'I', stackRefinedIronIngot,
                        'S', stackStoneSlab
                        });
        }

        // Upgrade/crafting recipe for advanced rails for both RailCraft and vanilla
        Recipes.advRecipes.addShapelessRecipe(
                new ItemStack(blockAdvancedElectricTrack, 1),
                new Object[] {
                    new ItemStack(blockAdvancedTrack),
                    stackIronCable
                    });

        // "Third Rail"

        if (isRailCraft)
        {
            // RailCraft
            Recipes.advRecipes.addShapelessRecipe(
                    new ItemStack(blockThirdRail, 3),
                    new Object[] {
                        stackStoneSlab,
                        stackElectricRail
                        });
        }
        else
        {
            // Vanilla
            Recipes.advRecipes.addShapelessRecipe(
                    new ItemStack(blockThirdRail, 2),
                    new Object[] {
                        stackStoneSlab,
                        stackIronCable
                        });
        }

        // Maglev Rail (magnet block)

        Recipes.advRecipes.addRecipe(
                new ItemStack(blockMaglevRail, 8),
                new Object[] {
                    "RCS", "SCS", "LCS",
                    'C', stackCopperCable,
                    'S', new ItemStack(Block.stone),
                    'R', new ItemStack(Item.redstone),
                    'L', stackLazurite
                    });

        // Maglev Cover (physical rails)

        Recipes.advRecipes.addShapelessRecipe(
                new ItemStack(blockMaglevCover, 8),
                new Object[] {
                    stackStoneSlab,
                    new ItemStack(Block.sand)
                    });
    }

    /* for debug only
    public void dropTagList()
    {
        Logger log = Logger.getLogger(Loader.instance().activeModContainer().getModId());
        log.info("RailCraft tags:");
        String[] tags = TagList.getTags().toArray(new String[0]);
        Arrays.sort(tags);
        for (String s : tags) log.info("\"" + s + "\"");
    } */
}
