/*
 * Decompiled with CFR 0.152.
 */
package mods.QuantumPack;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;

public class LangHelper {
    public static final String MASTER_LANG = "en_US";
    private final String modid = Loader.instance().activeModContainer().getModId();
    private final Logger log = Logger.getLogger(this.modid);
    private final Set languages = bp.a().b().keySet();
    private Set master = null;

    public static Properties reduce(Set master, Properties slave) {
        Properties result = new Properties();
        Set<String> keys = slave.stringPropertyNames();
        for (String key : keys) {
            if (!master.contains(key)) continue;
            result.setProperty(key, slave.getProperty(key));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadFromStream(InputStream input) {
        if (input == null) {
            return null;
        }
        Properties prop = new Properties();
        BufferedReader buf = new BufferedReader(new InputStreamReader(input, Charsets.UTF_8));
        try {
            String line = buf.readLine();
            if (line != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                do {
                    int n;
                    if (line.startsWith("#") || (n = line.indexOf(61)) == -1) continue;
                    String key = line.substring(0, n);
                    String value = line.substring(n + 1);
                    prop.setProperty(key, value);
                } while ((line = buf.readLine()) != null);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            prop = null;
        }
        finally {
            try {
                buf.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return prop;
    }

    public static Properties loadFromResource(String name) {
        return LangHelper.loadFromStream(LangHelper.class.getResourceAsStream(name));
    }

    public static Properties loadFromFile(String filename) {
        try {
            return LangHelper.loadFromStream(new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public Set getMaster() {
        return this.master;
    }

    public void setMaster(Set master) {
        this.master = master;
    }

    public void setMasterName(Object obj, String value) {
        String key;
        if (obj instanceof wk) {
            key = ((wk)obj).a();
        } else if (obj instanceof apa) {
            key = ((apa)obj).a();
        } else if (obj instanceof wm) {
            key = ((wm)obj).b().d((wm)obj);
        } else {
            throw new IllegalArgumentException(String.format("Illegal object for naming %s", obj));
        }
        this.setMasterName(key + ".name", value);
    }

    public void setMasterString(String key, String value) {
        if (this.master == null) {
            this.master = new HashSet();
        }
        this.master.add(key);
        LanguageRegistry.instance().addStringLocalization(key, value);
    }

    public void loadResources() {
        this.loadResources("/mods/" + this.modid + "/lang/");
    }

    public void loadResources(String subdir) {
        String path = subdir;
        if (path != "" && !path.endsWith("/")) {
            path = path + "/";
        }
        Properties p = LangHelper.loadFromResource(path + MASTER_LANG + ".txt");
        if (this.master == null || this.master.isEmpty()) {
            if (p == null || p.isEmpty()) {
                this.log.warning("Master localization not specified and could not be found into resources, aborting...");
                return;
            }
            this.master = p.stringPropertyNames();
        } else if (p != null && !p.isEmpty()) {
            p = LangHelper.reduce(this.master, p);
        }
        if (p != null && !p.isEmpty()) {
            LanguageRegistry.instance().addStringLocalization(p, MASTER_LANG);
        }
        for (Object lang : this.languages) {
            if (lang == MASTER_LANG || (p = LangHelper.loadFromResource(path + lang + ".txt")) == null || p.isEmpty() || (p = LangHelper.reduce(this.master, p)) == null || p.isEmpty()) continue;
            LanguageRegistry.instance().addStringLocalization(p, lang.toString());
        }
    }

    public void loadUserFiles() {
        this.loadUserFiles("mods/" + this.modid + "/lang/");
    }

    public void loadUserFiles(String subdir) {
        String path = Minecraft.b().getAbsolutePath();
        if (path == null || path == "") {
            this.log.warning("Cannot obtain minecraft path - translations will be unavailable.");
            return;
        }
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        if (!(path = path + subdir).endsWith(File.separator)) {
            path = path + File.separator;
        }
        File langPath = new File(path);
        this.log.info(String.format("Trying to look for language files into: \"%s\"", langPath.getAbsolutePath()));
        File[] files = langPath.listFiles();
        if (files == null || files.length == 0) {
            this.log.info("... directory either not exists or empty, done with that.");
            return;
        }
        Properties p = LangHelper.loadFromFile(path + MASTER_LANG + ".txt");
        if (this.master == null || this.master.isEmpty()) {
            if (p == null || p.isEmpty()) {
                this.log.warning("Master localization not specified and could not be found into user files, aborting...");
                return;
            }
            this.master = p.stringPropertyNames();
        } else if (p != null && !p.isEmpty()) {
            p = LangHelper.reduce(this.master, p);
        }
        if (p != null && !p.isEmpty()) {
            LanguageRegistry.instance().addStringLocalization(p, MASTER_LANG);
        }
        for (File file : files) {
            String filename;
            int n;
            if (file == null || (n = (filename = file.getName()).indexOf(46)) == -1 || !this.languages.contains(filename = filename.substring(0, n)) || (p = LangHelper.loadFromFile(file.getAbsolutePath())) == null || p.isEmpty() || (p = LangHelper.reduce(this.master, p)) == null || p.isEmpty()) continue;
            LanguageRegistry.instance().addStringLocalization(p, filename);
        }
    }

    public void loadAll() {
        this.loadResources();
        this.loadUserFiles();
        if (this.master == null || this.master.isEmpty()) {
            this.log.severe("Master localization is unspecified and it not found due resource and user file load.");
        }
    }
}

