package mods.QuantumPack;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.client.IItemRenderer;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class IconRenderer implements IItemRenderer
{
    @Override
    public boolean handleRenderType(ItemStack item, ItemRenderType type)
    {
        // Handle only item inventory rendering.
        return type == ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelper(ItemRenderType type, ItemStack item, ItemRendererHelper helper)
    {
        return false; // Don't need helper
    }

    @Override
    public void renderItem(ItemRenderType type, ItemStack stack, Object... data)
    {
        if (type == ItemRenderType.INVENTORY && stack != null)
        {
            Item item = stack.getItem();
            if (item != null)
            {
                // Check whether item requires multiple passes to render icon
                if (item.requiresMultipleRenderPasses())
                {
                    // Iterate through passes
                    int cPasses = item.getRenderPasses(stack.getItemDamage());
                    for (int pass = 0; pass < cPasses; pass++)
                    {
                        // Get icon for pass and render it
                        renderIcon(0, 0, 0, item.getIcon(stack, pass), 16, 16);
                    }
                }
                else
                {
                    // Otherwise render single icon
                    renderIcon(0, 0, 0, stack.getIconIndex(), 16, 16);
                }

                // Render bar, only for electric items
                if (item instanceof IElectricItem)
                {
                    // Get bar value
                    float value = (float) ElectricItem.manager.discharge(stack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true) / (float) ((IElectricItem) stack.getItem()).getMaxCharge(stack);

                    // Remember current texture
                    int oldTexture = GL11.glGetInteger(GL11.GL_TEXTURE_BINDING_2D);

                    // Reset texture and render bar
                    GL11.glBindTexture(GL11.GL_TEXTURE_2D, 0);
                    renderBar(value, 2, 13, 0.0D, 13, 2);

                    // Restore texture
                    GL11.glBindTexture(GL11.GL_TEXTURE_2D, oldTexture);
                }
            }
        }
    }

    public void renderIcon(int x, int y, int z, Icon icon, int w, int h)
    {
        if (icon != null)
        {
            Tessellator tessellator = Tessellator.instance;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(x + 0, y + h, z, icon.getMinU(), icon.getMaxV());
            tessellator.addVertexWithUV(x + w, y + h, z, icon.getMaxU(), icon.getMaxV());
            tessellator.addVertexWithUV(x + w, y + 0, z, icon.getMaxU(), icon.getMinV());
            tessellator.addVertexWithUV(x + 0, y + 0, z, icon.getMinU(), icon.getMinV());
            tessellator.draw();
        }
    }

    public void renderColoredQuad(int x, int y, double z, int w, int h, float r, float g, float b, float a)
    {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(r, g, b, a);
        tessellator.addVertex(x + 0, y + h, z);
        tessellator.addVertex(x + w, y + h, z);
        tessellator.addVertex(x + w, y + 0, z);
        tessellator.addVertex(x + 0, y + 0, z);
        tessellator.draw();
    }

    public void renderBar(float value, int x, int y, double z, int w, int h)
    {
        // Recalculate a bit
        int filled;
        int width = w;
        if (width < 0) width = -width; // abs
        if (value == 0 || width == 0)
            filled = 0;
        else
            filled = 1 + (int) (value * (width - 1));
        if (filled < 0) filled = 0; // clamp
        if (filled > width) filled = width;

        // Calculate color depending on fill level
        QuantumPack qp = QuantumPack.instance;
        float alpha = (float) filled / (float) width;
        float r = qp.barMaxR * alpha + qp.barMinR * (1 - alpha);
        float g = qp.barMaxG * alpha + qp.barMinG * (1 - alpha);
        float b = qp.barMaxB * alpha + qp.barMinB * (1 - alpha);

        // Render full-tone bar
        renderColoredQuad(x, y, z, filled, h - 1, r, g, b, 1.0F);

        // Render bar shadow (bottom)
        renderColoredQuad(x, y + h - 1, z, width, 1, 0, 0, 0, 1.0F);

        // Render bar background (quarter-tone bar)
        if (filled < width)
        {
            // Calculate dark color
            r /= 4.0F;
            g /= 4.0F;
            b /= 4.0F;

            // Render quarter-tone bar (unfilled part)
            renderColoredQuad(x + filled, y, z, width - filled - 1, h - 1, r, g, b, 1.0F);

            // Render shadow (unfilled right piece)
            renderColoredQuad(x + w - 1, y, z, 1, h - 1, 0, 0, 0, 1.0F);
        }
    }
}
