package mods.QuantumPack;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemGeneric extends Item
{
    public String iconName;

    @SideOnly(Side.CLIENT)
    public EnumRarity rarity;

    public ItemGeneric(int id, String iconName)
    {
        super(id);
        this.iconName = iconName;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister iconRegister)
    {
        itemIcon = iconRegister.registerIcon(iconName);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack)
    {
        return rarity;
    }

    @SideOnly(Side.CLIENT)
    public void setRarity(EnumRarity rarity)
    {
        this.rarity = rarity;
    }
}
