package mods.QuantumPack;

import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ToolboxInventory extends InventoryBasic
{
    ToolboxEnum type;

    // Create inventory from stack NBT
    public ToolboxInventory(ToolboxEnum type, ItemStack stack, boolean setOpened)
    {
        super(stack.getItem().getUnlocalizedName(stack) + (type == ToolboxEnum.CLASSIC ? "" : ".name"), false, type.inventorySize);
        readInventory(stack, setOpened);
    }

    // Read inventory from stack NBT
    public boolean readInventory(ItemStack stack, boolean setOpened)
    {
        // Check whether stack is toolbox
        if (stack != null)
        {
            Item item = stack.getItem();
            if (item != null && item instanceof ToolboxItem)
            {
                // Check whether stack have NBT
                NBTTagCompound nbt = null;
                if (stack.hasTagCompound())
                {
                    // Get NBT
                    nbt = stack.getTagCompound();

                    // Read items from NBT
                    int size = getSizeInventory();
                    for (int i = 0; i < size; i++)
                    {
                        // If there is stack stored for slot
                        if (nbt.hasKey("box" + i))
                        {
                            // Read slot
                            NBTTagCompound slot = nbt.getCompoundTag("box" + i);
                            setInventorySlotContents(i, ItemStack.loadItemStackFromNBT(slot));
                        }
                        else if (getStackInSlot(i) != null) // prevent call to onInventoryChanged() if inventory isn't actually changed, see setInventorySlotContents()
                        {
                            // Otherwise empty slot
                            setInventorySlotContents(i, null);
                        }
                    }
                }
                else
                {
                    // Or make a new one
                    nbt = new NBTTagCompound();
                    stack.setTagCompound(nbt);
                }

                // Write opened flag
                if (setOpened) nbt.setBoolean("opened", true);

                // Success
                return true;
            }
        }
        // Fail
        return false;
    }

    // Write inventory to stack NBT
    public boolean writeInventory(ItemStack stack, boolean setClosed)
    {
        // Check whether stack is toolbox
        if (stack != null)
        {
            Item item = stack.getItem();
            if (item != null && item instanceof ToolboxItem)
            {
                // *classic: metadata patch for classic toolbox
                // It should be equal to 1 if toolbox contains items
                // Or 0 if it empty
                int metadata = 0;

                // Get or create NBT
                NBTTagCompound nbt = ToolboxUtils.getOrCreateNBT(stack);

                // Write items
                int size = getSizeInventory();
                for (int i = 0; i < size; i++)
                {
                    // If slot contains item
                    ItemStack stack2 = getStackInSlot(i);
                    if (stack2 != null)
                    {
                        // Write it
                        NBTTagCompound slot = nbt.getCompoundTag("box" + i);
                        stack2.writeToNBT(slot);
                        nbt.setTag("box" + i, slot);
                        metadata = 1; // *classic: set to 1 if toolbox has at least one item
                    }
                    else
                    {
                        // Otherwise remove tag
                        nbt.removeTag("box" + i);
                    }
                }

                // Reset opened flag
                if (setClosed) nbt.setBoolean("opened", false);

                // *classic: patch metadata
                if (type == ToolboxEnum.CLASSIC) stack.setItemDamage(metadata);

                // Success
                return true;
            }
        }
        // Fail
        return false;
    }

    @Override
    public boolean isStackValidForSlot(int i, ItemStack stack)
    {
        return ToolboxUtils.canBeStoredInToolbox(stack);
    }
}
