package mods.QuantumPack;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ToolboxItem extends ItemGeneric
{
    ToolboxEnum type;
    public Icon itemIconOpened = null;

    public ToolboxItem(int id, String iconName, ToolboxEnum type)
    {
        super(id, iconName);
        setMaxStackSize(1);
        setHasSubtypes(true);
        setMaxDamage(0);
        setNoRepair();
        this.type = type;
    }

    public boolean isOpened(ItemStack stack)
    {
        return stack.hasTagCompound() && stack.getTagCompound().getBoolean("opened");
    }

    //======================================================================
    // Workaround for final modifier for getIconIndex(stack),
    // so item renderer call getIcon(stack,pass) instead.
    @Override
    @SideOnly(Side.CLIENT)
    public boolean requiresMultipleRenderPasses() { return true; }

    @Override
    public int getRenderPasses(int metadata) { return 1; }

    @Override
    public Icon getIcon(ItemStack stack, int pass)
    {
        return isOpened(stack) ? itemIconOpened : super.getIcon(stack, pass);
    }
    //======================================================================
    // Workaround for CLASSIC toolbox
    @Override
    public String getUnlocalizedName()
    {
        String name = super.getUnlocalizedName();
        if (type == ToolboxEnum.CLASSIC && name.startsWith("item."))
        {
            return "ic2." + name.substring(5);
        }
        return name;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack)
    {
        return getUnlocalizedName();
    }

    @Override
    public String getStatName()
    {
        return type == ToolboxEnum.CLASSIC ? StatCollector.translateToLocal(getUnlocalizedName()) : super.getStatName();
    }

    @Override
    public String func_77653_i(ItemStack stack)
    {
        return type == ToolboxEnum.CLASSIC ? StatCollector.translateToLocal(getUnlocalizedName(stack)) : super.func_77653_i(stack);
    }

    @Override
    public String getItemDisplayName(ItemStack stack)
    {
        return type == ToolboxEnum.CLASSIC ? StatCollector.translateToLocal(getUnlocalizedName(stack)) : super.getItemDisplayName(stack);
    }
    //======================================================================

    @Override
    @SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister iconRegister)
    {
        super.registerIcons(iconRegister);
        if (type == ToolboxEnum.CLASSIC)
            itemIconOpened = iconRegister.registerIcon(iconName + ".open");
        else
            itemIconOpened = iconRegister.registerIcon(iconName + "_open");
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player)
    {
        if (!player.isSneaking() && !world.isRemote)
        {
            player.openGui(QuantumPack.instance, type.ordinal(), world, player.inventory.currentItem, 0, 0);
        }
        return stack;
    }
}
