package mods.QuantumPack;

import ic2.api.item.ItemWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ToolboxUtils
{
    public static NBTTagCompound getOrCreateNBT(ItemStack stack)
    {
        NBTTagCompound nbt = stack.getTagCompound();
        if (nbt == null)
        {
            nbt = new NBTTagCompound();
            stack.setTagCompound(nbt);
        }
        return nbt;
    }

    public static boolean canBeStoredInToolbox(ItemStack stack)
    {
        if (stack == null) return false;
        Item item = stack.getItem();
        return item != null && (item.getItemStackLimit() == 1 || ItemWrapper.canBeStoredInToolbox(stack));
    }
}
