package mods.QuantumPack;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import cpw.mods.fml.common.Loader;

public class OreDictHelper
{
    public Set<String> oreNames;

    public OreDictHelper()
    {
        oreNames = new HashSet<String>(Arrays.asList(OreDictionary.getOreNames()));
    }

    /**
     * Lookup for ore name for a specified ItemStack. Does not create new OreDictionary entries.
     *
     * @param stack to find in OreDictionary.
     * @return ore name or the same stack.
     */
    public Object lookup(ItemStack stack)
    {
        int id = OreDictionary.getOreID(stack);
        if (id == -1) return stack;
        String name = OreDictionary.getOreName(id);
        if (name == "Unknown") return stack;
        return name;
    }

    /**
     * Lookup entries in the specified order. Entries can be following instances: String, ItemStack, Item, Block.
     * It is recommended to provide valid Item/Block/ItemStack for last entry as fall back semantic.
     * Does not create new OreDictionary entries.
     *
     * @param entries to lookup in OreDictionary.
     * @return ore name if it found, fall back item if it provided, or null otherwise.
     */
    public Object lookup(Object... entries)
    {
        for (Object obj : entries)
        {
            if (obj == null)
            {
                // skip
            }
            else if (obj instanceof String)
            {
                if (oreNames.contains(obj)) return obj;
            }
            else if (obj instanceof ItemStack)
            {
                Object ret = lookup((ItemStack) obj);
                if (ret != null) return ret;
            }
            else if (obj instanceof Item)
            {
                Object ret = lookup(new ItemStack((Item) obj));
                if (ret != null) return ret;
            }
            else if (obj instanceof Block)
            {
                Object ret = lookup(new ItemStack((Block) obj));
                if (ret != null) return ret;
            }
        }
        return null;
    }

    /**
     * Output all registered ore names to forge log.
     * For debug only.
     */
    public static void dumpOreNames()
    {
        Logger log = Logger.getLogger(Loader.instance().activeModContainer().getModId());
        log.info("== Ore names list begin ==");
        String[] oreNames = OreDictionary.getOreNames();
        Arrays.sort(oreNames);
        for (String s : oreNames) log.info("\"" + s + "\"");
        log.info("== Ore names list end ==");
    }
}
