package mods.QuantumPack;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ToolboxContainer extends Container
{
    public ToolboxInventory toolboxInventory;
    public int toolboxSlotIndex;

    public ToolboxContainer(EntityPlayer player, int toolboxSlotIndex, ToolboxEnum type)
    {
        this.toolboxSlotIndex = toolboxSlotIndex;
        this.toolboxInventory = new ToolboxInventory(type, player.inventory.getStackInSlot(toolboxSlotIndex), true);

        // Toolbox slots
        for (int y = 0; y < type.rows; y++)
            for (int x = 0; x < type.cols; x++)
                    addSlotToContainer(new ToolboxSlot(toolboxInventory, y * type.cols + x, type.offsetX + x * 18, type.offsetY + y * 18));

        // Player inventory slots
        for (int y = 0; y < 3; y++)
            for (int x = 0; x < 9; x++)
                addSlotToContainer(new ToolboxLockedSlot(player.inventory, x + y * 9 + 9, 8 + x * 18, type.guiHeight - 82 + y * 18));

        // Player hotbar slots
        for (int x = 0; x < 9; x++)
            addSlotToContainer(new ToolboxLockedSlot(player.inventory, x, 8 + x * 18, type.guiHeight - 24));
    }

    @Override
    public boolean canInteractWith(EntityPlayer player)
    {
        return true;
    }

    @Override
    public void onCraftGuiClosed(EntityPlayer player)
    {
        // Write inventory back to NBT
        toolboxInventory.writeInventory(player.inventory.getStackInSlot(toolboxSlotIndex), true);
        super.onCraftGuiClosed(player);
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex)
    {
        ItemStack itemstack = null;
        Slot slot = (Slot) this.inventorySlots.get(slotIndex);

        if (slot != null && slot.getHasStack())
        {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();

            if (slotIndex < toolboxInventory.getSizeInventory())
            {
                if (!this.mergeItemStack(itemstack1, toolboxInventory.getSizeInventory(), this.inventorySlots.size(), true))
                {
                    return null;
                }
            }
            else if (!ToolboxUtils.canBeStoredInToolbox(itemstack1) || !this.mergeItemStack(itemstack1, 0, toolboxInventory.getSizeInventory(), false))
            {
                return null;
            }

            if (itemstack1.stackSize == 0)
            {
                slot.putStack((ItemStack)null);
            }
            else
            {
                slot.onSlotChanged();
            }
        }

        return itemstack;
    }
}
