package mods.QuantumPack;

import ic2.api.item.IElectricItem;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemElectricStorage extends ItemGeneric implements IElectricItem
{
    public int maxCharge;
    public int tier;
    public int transferLimit;
    public boolean supportRightClick;

    public ItemElectricStorage(int id, String iconName, int maxCharge, int transferLimit, int tier, boolean supportRightClick)
    {
        super(id, iconName);
        setMaxStackSize(1);
        setHasSubtypes(false);
        setMaxDamage(0);
        setNoRepair();

        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        this.supportRightClick = supportRightClick;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack src, World world, EntityPlayer player)
    {
        if (supportRightClick) QuantumPack.chargeInventoryItem(src, player);
        return src;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void getSubItems(int id, CreativeTabs tab, List list)
    {
        QuantumPack.getCreativeItems(this, list);
    }

    // ---------------------------- IElectricItem ----------------------------

    @Override
    public int getChargedItemId(ItemStack itemStack)
    {
        return itemID;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack)
    {
        return itemID;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack)
    {
        return true;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack)
    {
        return maxCharge;
    }

    @Override
    public int getTier(ItemStack itemStack)
    {
        return tier;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack)
    {
        return transferLimit;
    }
}
