package mods.QuantumPack;

import ic2.api.item.IElectricItem;

import java.util.List;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemElectricArmor extends ItemArmor implements ISpecialArmor, IElectricItem
{
    public String iconName;
    public int maxCharge;
    public int tier;
    public int transferLimit;
    public boolean supportRightClick;

    @SideOnly(Side.CLIENT)
    public EnumRarity rarity;

    public ItemElectricArmor(int id, String iconName, EnumArmorMaterial material, int renderIndex, int armorType, int maxCharge, int transferLimit, int tier, boolean supportRightClick)
    {
        super(id, material, renderIndex, armorType);
        setMaxStackSize(1);
        setHasSubtypes(false);
        setMaxDamage(0);
        setNoRepair();

        this.iconName = iconName;
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        this.supportRightClick = supportRightClick;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister iconRegister)
    {
        itemIcon = iconRegister.registerIcon(iconName);
    }

    @Override
    @SideOnly(Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack)
    {
        return rarity;
    }

    @SideOnly(Side.CLIENT)
    public void setRarity(EnumRarity rarity)
    {
        this.rarity = rarity;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack src, World world, EntityPlayer player)
    {
        if (supportRightClick) QuantumPack.chargeInventoryItem(src, player);
        return src;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void getSubItems(int id, CreativeTabs tab, List list)
    {
        QuantumPack.getCreativeItems(this, list);
    }

    // ---------------------------- IElectricItem ----------------------------

    @Override
    public int getChargedItemId(ItemStack itemStack)
    {
        return itemID;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack)
    {
        return itemID;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack)
    {
        return true;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack)
    {
        return maxCharge;
    }

    @Override
    public int getTier(ItemStack itemStack)
    {
        return tier;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack)
    {
        return transferLimit;
    }

    // ---------------------------- ISpecialArmor ----------------------------

    @Override
    public ArmorProperties getProperties(EntityLiving player, ItemStack armor, DamageSource source, double damage, int slot)
    {
        ArmorProperties p = new ArmorProperties(0, 0, 0);
        p.Slot = slot;
        return p;
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot)
    {
        return 0;
    }

    @Override
    public void damageArmor(EntityLiving entity, ItemStack stack, DamageSource source, int damage, int slot)
    {
        // do nothing
    }
}
