package mods.QuantumPack;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.Items;
import ic2.api.recipe.Recipes;

import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@Mod(modid = "QuantumPack", name = "QuantumPack", version = "1.10", dependencies = "required-after:IC2")
@NetworkMod(clientSideRequired = true, serverSideRequired = true)
public class QuantumPack
{
    // The instance of mod that Forge uses.
    @Instance("QuantumPack")
    public static QuantumPack instance;

    // Says where the client and server 'proxy' code is loaded.
    @SidedProxy(clientSide = "mods.QuantumPack.ClientProxy", serverSide = "mods.QuantumPack.CommonProxy")
    public static CommonProxy proxy;

    // Const

    public static String ICON_BASE = "QuantumPack:";

    // Config

    public boolean lightAlloyEnabled = true;
    public int lightAlloyId = 29957;

    public boolean quantumPackEnabled = true;
    public int quantumPackId = 29956;
    public int quantumPackMaxCharge = 1200000;
    public int quantumPackTransferLimit = 1000;
    public int quantumPackTier = 3;
    public boolean quantumPackRightClick = false;

    public boolean quantumAccumulatorEnabled = true;
    public int quantumAccumulatorId = 29955;
    public int quantumAccumulatorMaxCharge = 900000;
    public int quantumAccumulatorTransferLimit = 1000;
    public int quantumAccumulatorTier = 1;
    public boolean quantumAccumulatorRightClick = true;

    public boolean quantumAccumulatorBigEnabled = true;
    public int quantumAccumulatorBigId = 29954;
    public int quantumAccumulatorBigMaxCharge = 5400000;
    public int quantumAccumulatorBigTransferLimit = 6000;
    public int quantumAccumulatorBigTier = 1;
    public boolean quantumAccumulatorBigRightClick = false;

    public boolean industrialBeltEnabled = true;
    public int industrialBeltId = 29953;
    public int industrialBeltMaxCharge = 30000;
    public int industrialBeltTransferLimit = 100;
    public int industrialBeltTier = 1;
    public boolean industrialBeltRightClick = false;

    public boolean quantumToolboxEnabled = true;
    public int quantumToolboxId = 29952;

    public boolean nanoToolboxEnabled = true;
    public int nanoToolboxId = 29951;

    public boolean classicToolboxReplace = false;

    public float barMinR; // 131
    public float barMinG; // 58
    public float barMinB; // 255

    public float barMaxR; // 10
    public float barMaxG; // 240
    public float barMaxB; // 255

    public boolean debugDumpOreNames = false;

    // Items

    public ItemGeneric lightAlloy = null;
    public ItemElectricArmor quantumPack = null;
    public ItemElectricStorage quantumAccumulator = null;
    public ItemElectricStorage quantumAccumulatorBig = null;
    public ItemElectricArmor industrialBelt = null;
    public ToolboxItem quantumToolbox = null;
    public ToolboxItem nanoToolbox = null;
    public ToolboxItem classicToolbox = null;

    // Helper function - read color from config, clamp it and normalize
    public static float getColor(Configuration config, String category, String key, int defaultValue)
    {
        int value = config.get(category, key, defaultValue).getInt(defaultValue);
        if (value >= 255)
            return 1.0F;
        else if (value < 0)
            return 0.0F;
        else
            return value / 255.0F;
    }

    @PreInit
    public void preInit(FMLPreInitializationEvent event)
    {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try
        {
            config.load();

            lightAlloyEnabled = config.get("LightAlloy", "enabled", lightAlloyEnabled).getBoolean(lightAlloyEnabled);
            lightAlloyId      = config.get("LightAlloy", "id", lightAlloyId).getInt(lightAlloyId);

            quantumPackEnabled       = config.get("QuantumPack", "enabled", quantumPackEnabled).getBoolean(quantumPackEnabled);
            quantumPackId            = config.get("QuantumPack", "id", quantumPackId).getInt(quantumPackId);
            quantumPackMaxCharge     = config.get("QuantumPack", "maxCharge", quantumPackMaxCharge).getInt(quantumPackMaxCharge);
            quantumPackTransferLimit = config.get("QuantumPack", "transferLimit", quantumPackTransferLimit).getInt(quantumPackTransferLimit);
            quantumPackTier          = config.get("QuantumPack", "tier", quantumPackTier).getInt(quantumPackTier);
            quantumPackRightClick    = config.get("QuantumPack", "rightClickUse", quantumPackRightClick).getBoolean(quantumPackRightClick);

            quantumAccumulatorEnabled       = config.get("QuantumAccumulator", "enabled", quantumAccumulatorEnabled).getBoolean(quantumAccumulatorEnabled);
            quantumAccumulatorId            = config.get("QuantumAccumulator", "id", quantumAccumulatorId).getInt(quantumAccumulatorId);
            quantumAccumulatorMaxCharge     = config.get("QuantumAccumulator", "maxCharge", quantumAccumulatorMaxCharge).getInt(quantumAccumulatorMaxCharge);
            quantumAccumulatorTransferLimit = config.get("QuantumAccumulator", "transferLimit", quantumAccumulatorTransferLimit).getInt(quantumAccumulatorTransferLimit);
            quantumAccumulatorTier          = config.get("QuantumAccumulator", "tier", quantumAccumulatorTier).getInt(quantumAccumulatorTier);
            quantumAccumulatorRightClick    = config.get("QuantumAccumulator", "rightClickUse", quantumAccumulatorRightClick).getBoolean(quantumAccumulatorRightClick);

            quantumAccumulatorBigEnabled       = config.get("BigQuantumAccumulator", "enabled", quantumAccumulatorBigEnabled).getBoolean(quantumAccumulatorBigEnabled);
            quantumAccumulatorBigId            = config.get("BigQuantumAccumulator", "id", quantumAccumulatorBigId).getInt(quantumAccumulatorBigId);
            quantumAccumulatorBigMaxCharge     = config.get("BigQuantumAccumulator", "maxCharge", quantumAccumulatorBigMaxCharge).getInt(quantumAccumulatorBigMaxCharge);
            quantumAccumulatorBigTransferLimit = config.get("BigQuantumAccumulator", "transferLimit", quantumAccumulatorBigTransferLimit).getInt(quantumAccumulatorBigTransferLimit);
            quantumAccumulatorBigTier          = config.get("BigQuantumAccumulator", "tier", quantumAccumulatorBigTier).getInt(quantumAccumulatorBigTier);
            quantumAccumulatorBigRightClick    = config.get("BigQuantumAccumulator", "rightClickUse", quantumAccumulatorBigRightClick).getBoolean(quantumAccumulatorBigRightClick);

            industrialBeltEnabled       = config.get("IndustrialBelt", "enabled", industrialBeltEnabled).getBoolean(industrialBeltEnabled);
            industrialBeltId            = config.get("IndustrialBelt", "id", industrialBeltId).getInt(industrialBeltId);
            industrialBeltMaxCharge     = config.get("IndustrialBelt", "maxCharge", industrialBeltMaxCharge).getInt(industrialBeltMaxCharge);
            industrialBeltTransferLimit = config.get("IndustrialBelt", "transferLimit", industrialBeltTransferLimit).getInt(industrialBeltTransferLimit);
            industrialBeltTier          = config.get("IndustrialBelt", "tier", industrialBeltTier).getInt(industrialBeltTier);
            industrialBeltRightClick    = config.get("IndustrialBelt", "rightClickUse", industrialBeltRightClick).getBoolean(industrialBeltRightClick);

            quantumToolboxEnabled = config.get("QuantumToolBox", "enabled", quantumToolboxEnabled).getBoolean(quantumToolboxEnabled);
            quantumToolboxId      = config.get("QuantumToolBox", "id", quantumToolboxId).getInt(quantumToolboxId);

            nanoToolboxEnabled = config.get("NanoToolBox", "enabled", nanoToolboxEnabled).getBoolean(nanoToolboxEnabled);
            nanoToolboxId      = config.get("NanoToolBox", "id", nanoToolboxId).getInt(nanoToolboxId);

            classicToolboxReplace = config.get("ClassicToolBox", "replace", classicToolboxReplace, "Use at you own risk! Replaces classic IC2 toolbox with the same, but with GUI, it may be internally incompatible and you will loose all items.").getBoolean(classicToolboxReplace);

            barMinR = getColor(config, "ChargeBar", "minRed", 131);
            barMinG = getColor(config, "ChargeBar", "minGreen", 58);
            barMinB = getColor(config, "ChargeBar", "minBlue", 255);

            barMaxR = getColor(config, "ChargeBar", "maxRed", 10);
            barMaxG = getColor(config, "ChargeBar", "maxGreen", 240);
            barMaxB = getColor(config, "ChargeBar", "maxBlue", 255);

            debugDumpOreNames = config.get("Debug", "dumpOreNames", debugDumpOreNames).getBoolean(debugDumpOreNames);
        }
        finally
        {
            config.save();
        }
    }

    @Init
    public void load(FMLInitializationEvent event)
    {
        boolean client = event.getSide().isClient();
        ItemStack lapotronCrystal = Items.getItem("lapotronCrystal");

        CreativeTabs creativeTab = null;
        if (client) creativeTab = lapotronCrystal.getItem().getCreativeTab();

        // Creating new items

        // Light Alloy

        if (lightAlloyEnabled)
        {
            lightAlloy = new ItemGeneric(lightAlloyId - 256, ICON_BASE + "light_alloy");
            lightAlloy.setUnlocalizedName("plateAlloyLight");
            lightAlloy.setNoRepair();
            GameRegistry.registerItem(lightAlloy, "plateAlloyLight");
            OreDictionary.registerOre("plateAlloyLight", lightAlloy);
            if (client)
            {
                lightAlloy.setCreativeTab(creativeTab);
                lightAlloy.setRarity(EnumRarity.common);
            }
        }

        // Quantum Pack

        if (quantumPackEnabled)
        {
            quantumPack = new ItemElectricArmor(quantumPackId - 256, ICON_BASE + "quantum_pack", EnumArmorMaterial.IRON, proxy.addNewArmourRendererPrefix("ic2/qpack"), 1, quantumPackMaxCharge, quantumPackTransferLimit, quantumPackTier, quantumPackRightClick);
            quantumPack.setUnlocalizedName("quantumPack");
            GameRegistry.registerItem(quantumPack, "quantumPack");
            if (client)
            {
                quantumPack.setCreativeTab(creativeTab);
                quantumPack.setRarity(EnumRarity.rare);
                proxy.registerIconRenderer(quantumPack);
            }
        }

        // Quantum Accumulator

        if (quantumAccumulatorEnabled)
        {
            quantumAccumulator = new ItemElectricStorage(quantumAccumulatorId - 256, ICON_BASE + "quantum_accumulator", quantumAccumulatorMaxCharge, quantumAccumulatorTransferLimit, quantumAccumulatorTier, quantumAccumulatorRightClick);
            quantumAccumulator.setUnlocalizedName("quantumAccumulator");
            GameRegistry.registerItem(quantumAccumulator, "quantumAccumulator");
            if (client)
            {
                quantumAccumulator.setCreativeTab(creativeTab);
                quantumAccumulator.setRarity(EnumRarity.uncommon);
                proxy.registerIconRenderer(quantumAccumulator);
            }
        }

        // Big Quantum Accumulator

        if (quantumAccumulatorBigEnabled)
        {
            quantumAccumulatorBig = new ItemElectricStorage(quantumAccumulatorBigId - 256, ICON_BASE + "quantum_accumulator_big", quantumAccumulatorBigMaxCharge, quantumAccumulatorBigTransferLimit, quantumAccumulatorBigTier, quantumAccumulatorBigRightClick);
            quantumAccumulatorBig.setUnlocalizedName("quantumAccumulatorBig");
            GameRegistry.registerItem(quantumAccumulatorBig, "quantumAccumulatorBig");
            if (client)
            {
                quantumAccumulatorBig.setCreativeTab(creativeTab);
                quantumAccumulatorBig.setRarity(EnumRarity.rare);
                proxy.registerIconRenderer(quantumAccumulatorBig);
            }
        }

        // Industrial Belt

        if (industrialBeltEnabled)
        {
            industrialBelt = new ItemElectricArmor(industrialBeltId - 256, ICON_BASE + "industrial_belt", EnumArmorMaterial.IRON, proxy.addNewArmourRendererPrefix("ic2/qpack"), 2, industrialBeltMaxCharge, industrialBeltTransferLimit, industrialBeltTier, industrialBeltRightClick);
            industrialBelt.setUnlocalizedName("industrialBelt");
            GameRegistry.registerItem(industrialBelt, "industrialBelt");
            if (client)
            {
                industrialBelt.setCreativeTab(creativeTab);
                industrialBelt.setRarity(EnumRarity.common);
                proxy.registerIconRenderer(industrialBelt);
            }
        }

        // Quantum Tool Box

        if (quantumToolboxEnabled)
        {
            quantumToolbox = new ToolboxItem(quantumToolboxId - 256, ICON_BASE + "toolbox_quantum", ToolboxEnum.QUANTUM);
            quantumToolbox.setUnlocalizedName("quantumToolBox");
            GameRegistry.registerItem(quantumToolbox, "quantumToolBox");
            if (client)
            {
                quantumToolbox.setCreativeTab(creativeTab);
                quantumToolbox.setRarity(EnumRarity.rare);
            }
        }

        // Nano Tool Box

        if (nanoToolboxEnabled)
        {
            nanoToolbox = new ToolboxItem(nanoToolboxId - 256, ICON_BASE + "toolbox_nano", ToolboxEnum.NANO);
            nanoToolbox.setUnlocalizedName("nanoToolBox");
            GameRegistry.registerItem(nanoToolbox, "nanoToolBox");
            if (client)
            {
                nanoToolbox.setCreativeTab(creativeTab);
                nanoToolbox.setRarity(EnumRarity.uncommon);
            }
        }

        // Try to replace classic toolbox

        if (classicToolboxReplace)
        {
            ItemStack parent = Items.getItem("toolbox");
            if (parent != null)
            {
                Item parentItem = parent.getItem(); // save item data before changing it
                String unlocalizedName = parentItem.getUnlocalizedName();

                Object rarity = null; // cannot access Enum classes directly, so use polymorphism
                if (client) rarity = parent.getRarity();

                classicToolbox = new ToolboxItem(parentItem.itemID - 256, "ic2:" + unlocalizedName, ToolboxEnum.CLASSIC);
                classicToolbox.setUnlocalizedName(unlocalizedName);
                if (client)
                {
                    classicToolbox.setCreativeTab(creativeTab);
                    classicToolbox.setRarity((EnumRarity) rarity);
                }
            }
        }

        // Register GUI handler
        NetworkRegistry.instance().registerGuiHandler(instance, new GuiHandler());

        // Load translations
        proxy.loadLangs();
    }

    @PostInit
    public void postInit(FMLPostInitializationEvent event)
    {
        if (debugDumpOreNames) OreDictHelper.dumpOreNames();

        // Import items

        ItemStack stackLapPack = Items.getItem("lapPack");

        // Try to lookup for aliases in ore dictionary

        OreDictHelper h = new OreDictHelper();

        Object advancedCircuit = h.lookup(Items.getItem("advancedCircuit"));
        Object iridiumAlloy    = h.lookup(Items.getItem("iridiumPlate"));
        Object lapotronCrystal = h.lookup(Items.getItem("lapotronCrystal"));
        Object carbonPlate     = h.lookup(Items.getItem("carbonPlate"));
        Object fiberGlassCable = h.lookup(Items.getItem("glassFiberCableItem"));
        Object rubber          = h.lookup(Items.getItem("rubber"));
        Object leather         = h.lookup(new ItemStack(Item.leather, 1, 0));
        Object toolbox         = h.lookup("toolbox", Items.getItem("toolbox"), new ItemStack(Block.chest));

        // Try to use GregTech plates first

        Object iridium = h.lookup("plateIridium", "ingotIridium", Items.getItem("iridiumOre"));
        Object tin     = h.lookup("plateTin", Items.getItem("tinIngot"));

        // Register recipes

        // Light Alloy

        Object alloy = iridiumAlloy; // determine whether light alloy or iridium plate should be used

        if (lightAlloy != null)
        {
            ItemStack stackLightAlloy = new ItemStack(lightAlloy);

            Recipes.advRecipes.addRecipe(
                    stackLightAlloy,
                    new Object[] {
                        " A ", "ABA", " A ",
                        'A', tin,
                        'B', iridium
                        });

            alloy = h.lookup("plateAlloyLight", stackLightAlloy);
        }

        // Quantum Pack

        if (quantumPack != null)
        {
            ItemStack stack = new ItemStack(quantumPack);

            Recipes.advRecipes.addRecipe(
                    stack,
                    new Object[] {
                            " A ", "BCB", " D ",
                            'A', advancedCircuit,
                            'B', alloy,
                            'C', stackLapPack,
                            'D', lapotronCrystal
                            });

            Recipes.advRecipes.addRecipe(
                    stack,
                    new Object[] {
                            " D ", "BCB", " A ",
                            'A', advancedCircuit,
                            'B', alloy,
                            'C', stackLapPack,
                            'D', lapotronCrystal
                            });
        }

        // Quantum Accumulator

        ItemStack stackQuantumAccumulator = null;
        if (quantumAccumulator != null)
        {
            stackQuantumAccumulator = new ItemStack(quantumAccumulator);

            Recipes.advRecipes.addRecipe(
                    stackQuantumAccumulator,
                    new Object[] {
                            "ABA", "CDC", "CEC",
                            'A', carbonPlate,
                            'B', fiberGlassCable,
                            'C', rubber,
                            'D', lapotronCrystal,
                            'E', alloy
                            });
        }

        // Big Quantum Accumulator

        if (quantumAccumulatorBig != null)
        {
            if (stackQuantumAccumulator != null)
            {
                Recipes.advRecipes.addRecipe(
                        new ItemStack(quantumAccumulatorBig),
                        new Object[] {
                            "ABA", "CCC", "CCC",
                            'A', fiberGlassCable,
                            'B', carbonPlate,
                            'C', stackQuantumAccumulator
                            });
            }
            else
            {
                Recipes.advRecipes.addRecipe(
                        new ItemStack(quantumAccumulatorBig),
                        new Object[] {
                            "ABA", "CCC", "CCC",
                            'A', iridiumAlloy,
                            'B', carbonPlate,
                            'C', lapotronCrystal
                            });
            }
        }

        // Industrial Belt

        if (industrialBelt != null)
        {
            ItemStack stack = new ItemStack(industrialBelt);
            ItemStack reBattery = Items.getItem("reBattery");

            Recipes.advRecipes.addRecipe(
                    stack,
                    new Object[] {
                            "RLL", "DDD",
                            'R', rubber,
                            'L', leather,
                            'D', h.lookup(reBattery)
                            });

            Recipes.advRecipes.addRecipe(
                    stack,
                    new Object[] {
                            "RLL", "DDD",
                            'R', rubber,
                            'L', leather,
                            'D', h.lookup(Items.getItem("chargedReBattery"))
                            });

            // Partial decrafting recipe

            Recipes.advRecipes.addShapelessRecipe(
                    new ItemStack(reBattery.getItem(), 3),
                    new Object[] {stack}
                    );
        }

        // Nano Tool Box

        ItemStack stackNanoToolBox = null;
        if (nanoToolbox != null)
        {
            stackNanoToolBox = new ItemStack(nanoToolbox);

            Recipes.advRecipes.addRecipe(
                    stackNanoToolBox,
                    "CTC", "CCC",
                    'C', carbonPlate,
                    'T', toolbox
                    );
        }

        // Quantum Tool Box

        if (quantumToolbox != null)
        {
            Recipes.advRecipes.addRecipe(
                    new ItemStack(quantumToolbox),
                    "TNT", (lightAlloy != null ? "ITI" : "TIT"),
                    'T', tin,
                    'I', alloy,
                    'N', stackNanoToolBox == null ? toolbox : stackNanoToolBox
                    );
        }
    }

    // Utils

    public static void chargeInventoryItem(ItemStack src, EntityPlayer player)
    {
        if (src.getItem() instanceof IElectricItem)
        {
            IElectricItem e = (IElectricItem) src.getItem();
            int srcTransferLimit = e.getTransferLimit(src);
            int srcTier = e.getTier(src);

            // Iterate through items
            for (ItemStack dst : player.inventory.mainInventory)
            {
                // Check whether it is suitable item
                if (dst != null && dst.getItem() instanceof IElectricItem && dst != src)
                {
                    e = (IElectricItem) dst.getItem();
                    int dstTier = e.getTier(dst);

                    int count = ElectricItem.manager.discharge(src, Math.min(srcTransferLimit, e.getTransferLimit(dst)), dstTier, true, true); // determine how much energy can be transferred
                    count = ElectricItem.manager.charge(dst, count, srcTier, true, false); // charge target item
                    ElectricItem.manager.discharge(src, count, dstTier, true, false); // actually discharge source

                    if (count != 0) break; // finish if item successfully charged
                }
            }
        }
    }

    @SideOnly(Side.CLIENT)
    public static void getCreativeItems(Item item, List<ItemStack> list)
    {
        ItemStack empty = new ItemStack(item);
        ElectricItem.manager.discharge(empty, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        list.add(empty);

        ItemStack full = new ItemStack(item);
        ElectricItem.manager.charge(full, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        list.add(full);
    }
}
