package mods.QuantumPack;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

import org.lwjgl.opengl.GL11;

public class ToolboxGUI extends GuiContainer
{
    ToolboxEnum type;
    //public int rowSize;

    public ToolboxGUI(EntityPlayer player, int toolboxSlotIndex, ToolboxEnum type)
    {
        super(new ToolboxContainer(player, toolboxSlotIndex, type));
        this.type = type;
        this.xSize = type.guiWidth;
        this.ySize = type.guiHeight;
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY)
    {
        fontRenderer.drawString(StatCollector.translateToLocal( ((ToolboxContainer) inventorySlots).toolboxInventory.getInvName() ), 8, 6, 4210752);
        fontRenderer.drawString(StatCollector.translateToLocal("container.inventory"), 8, ySize - 93, 4210752);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3)
    {
        mc.renderEngine.bindTexture(type.guiBackground);
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        drawTexturedModalRect(guiLeft, guiTop, 0, 0, xSize, ySize);
    }

    //======================================================================
    // InvTweaks API
    /*@RowSizeCallback
    public int rowSizeCallback()
    {
        return rowSize;
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> containerSectionCallback()
    {
        List slots = this.inventorySlots.inventorySlots;

        Map<ContainerSection, List<Slot>> slotRefs = new HashMap<ContainerSection, List<Slot>>();
        slotRefs.put(  ContainerSection.CHEST,      slots.subList(0, type.inventorySize)  );
        slotRefs.put(  ContainerSection.INVENTORY,  slots.subList(type.inventorySize, slots.size())  );
        return slotRefs;
    }*/
    //======================================================================
}
