/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.util;

import java.io.File;
import net.minecraftforge.common.Configuration;
import phero.mods.advancedreactors.AdvancedReactors;

public class Config {
    public static final String MODID = "AdvancedReactors";
    public static final String VERSION = "1.0.4-exp";
    public static boolean reactorChambersUseLeadPlates = false;
    public static boolean infernalPlatesUseCopperPlates = false;
    public static boolean disableClassicReactors = true;
    public static boolean cheapLeadPlateRecipe = false;
    public static boolean enableSounds = true;
    public static int highTempMachineBlockId = 1930;
    public static int reactorId = 1931;
    public static int reactorChamberId = 1932;
    public static int reactorRegulatorId = 1933;
    public static int lapisPlateId = 11930;
    public static int infernalReactorVentId = 11931;
    public static int quartzCondensatorId = 11932;
    public static int infernalPlateId = 11933;
    public static int obsidianPlateId = 11934;
    public static int dustObsidianId = 11935;
    public static int obsidianNeutronReflectorId = 11936;
    public static int thickObsidianNeutronReflectorId = 11937;
    public static int weepingCoolantCellId = 11938;
    public static int plateDenseLeadId = 11939;
    public static int ingotInfernalId = 11940;
    public static String steamReactorOutput = "steam";

    public static void load(File configFile) {
        String debugEnv;
        Configuration config = new Configuration(configFile);
        if (config != null) {
            config.load();
            reactorChambersUseLeadPlates = config.get("config", "reactorChambersUseLeadPlates", false, "should reactor chambers be crafted with lead plates (if available), default is copper").getBoolean(reactorChambersUseLeadPlates);
            infernalPlatesUseCopperPlates = config.get("config", "infernalPlatesUseCopperPlates", false, "if set to true, infernal plates will be crafted (the old style) with a dense copper plate, if false the recipe will resemble advanced alloy (newer) instead").getBoolean(infernalPlatesUseCopperPlates);
            cheapLeadPlateRecipe = config.get("config", "cheapLeadPlateRecipe", false, "if lead plates should be cheap (4 lead) instead of normal (8)").getBoolean(false);
            enableSounds = config.get("config", "enableSounds", true, "enable advanced reactor running sounds").getBoolean(true);
            disableClassicReactors = config.get("compat", "disableClassicReactors", true, "set this to false to re-enable classic IC2 reactors and chambers, by default they should be disabled as they will cause balance issues when used with advanced reactors").getBoolean(true);
            highTempMachineBlockId = config.getBlock("highTempMachineBlock", highTempMachineBlockId, "id for the high temperature machine block").getInt(highTempMachineBlockId);
            reactorId = config.getBlock("reactor", reactorId, "Shared id for the Reactor cores").getInt(reactorId);
            reactorChamberId = config.getBlock("reactorChamber", reactorChamberId, "Shared id for the Reactor chambers").getInt(reactorChamberId);
            lapisPlateId = config.getItem("lapisPlate", lapisPlateId, "id for the lapis plate (this will be skipped if gregtech is enabled)").getInt(lapisPlateId);
            infernalReactorVentId = config.getItem("infernalReactorVent", infernalReactorVentId, "id for the infernal reactor vent").getInt(infernalReactorVentId);
            quartzCondensatorId = config.getItem("quartzCondensator", quartzCondensatorId, "id for the quartz condensator").getInt(quartzCondensatorId);
            infernalPlateId = config.getItem("infernalPlateId", infernalPlateId, "id for the infernal plate").getInt(infernalPlateId);
            obsidianPlateId = config.getItem("obsidianPlateId", obsidianPlateId, "id for the obsidian plate").getInt(obsidianPlateId);
            dustObsidianId = config.getItem("dustObsidianId", dustObsidianId, "id for the obsidian dust").getInt(dustObsidianId);
            obsidianNeutronReflectorId = config.getItem("obsidianNeutronReflectorId", obsidianNeutronReflectorId, "id for the obsidian neutron reflector").getInt(obsidianNeutronReflectorId);
            thickObsidianNeutronReflectorId = config.getItem("thickObsidianNeutronReflectorId", thickObsidianNeutronReflectorId, "id for the thick obsidian neutron reflector").getInt(thickObsidianNeutronReflectorId);
            weepingCoolantCellId = config.getItem("weepingCoolantCellId", weepingCoolantCellId, "id for the weeping coolant cell").getInt(weepingCoolantCellId);
            plateDenseLeadId = config.getItem("leadPlateId", plateDenseLeadId, "id for the dense lead plate").getInt(plateDenseLeadId);
            ingotInfernalId = config.getItem("ingotInfernalId", ingotInfernalId, "id for the infernal ingot").getInt(ingotInfernalId);
            config.save();
        }
        if ((debugEnv = System.getenv("debug")) != null && debugEnv.equals("true")) {
            AdvancedReactors.logger.info("Detected debug development environment - replacing steam reactors output with water");
            steamReactorOutput = "water";
        }
    }
}

