/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.util;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.item.Items;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.Recipes;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import phero.mods.advancedreactors.AdvancedReactors;
import phero.mods.advancedreactors.blocks.BlockHighTempMachine;
import phero.mods.advancedreactors.blocks.BlockReactor;
import phero.mods.advancedreactors.blocks.BlockReactorChamber;
import phero.mods.advancedreactors.blocks.ItemBlockReactor;
import phero.mods.advancedreactors.blocks.ItemBlockReactorChamber;
import phero.mods.advancedreactors.blocks.ReactorChamberType;
import phero.mods.advancedreactors.blocks.ReactorType;
import phero.mods.advancedreactors.items.ItemAR;
import phero.mods.advancedreactors.items.ItemHeatAbsorber;
import phero.mods.advancedreactors.items.ItemInfernalReactorVent;
import phero.mods.advancedreactors.items.ItemReactorCondensator;
import phero.mods.advancedreactors.items.ItemReactorReflector;
import phero.mods.advancedreactors.items.ItemWeepingCoolantCell;
import phero.mods.advancedreactors.util.Config;
import phero.mods.advancedreactors.util.RechargeRecipe;

public class ModItems {
    public static Block blockHighTempMachine = null;
    public static Block blockReactor = null;
    public static Block blockReactorChamber = null;
    public static Block blockReactorRegulator = null;
    public static Item lapisPlate = null;
    public static Item infernalReactorVent = null;
    public static Item quartzCondensator = null;
    public static Item infernalPlate = null;
    public static Item dustObsidian = null;
    public static Item obsidianPlate = null;
    public static Item obsidianNeutronReflector = null;
    public static Item thickObsidianNeutronReflector = null;
    public static Item weepingCoolantCell = null;
    public static Item plateDenseLead = null;
    public static Item ingotInfernal = null;

    public static void init() {
        blockHighTempMachine = new BlockHighTempMachine(Config.highTempMachineBlockId).func_71864_b("highTempMachine");
        GameRegistry.registerBlock((Block)blockHighTempMachine, (String)"highTempMachine");
        blockReactor = new BlockReactor(Config.reactorId);
        GameRegistry.registerBlock((Block)blockReactor, ItemBlockReactor.class, (String)"nuclearReactor");
        for (ReactorType reactorType : ReactorType.values()) {
            new ItemStack(blockReactor, 1, reactorType.ordinal());
        }
        blockReactorChamber = new BlockReactorChamber(Config.reactorChamberId);
        GameRegistry.registerBlock((Block)blockReactorChamber, ItemBlockReactorChamber.class, (String)"reactorChamber");
        for (Enum enum_ : ReactorChamberType.values()) {
            new ItemStack(blockReactorChamber, 1, enum_.ordinal());
        }
        lapisPlate = new ItemAR(Config.lapisPlateId).func_77655_b("plateDenseLapis");
        infernalReactorVent = new ItemInfernalReactorVent(Config.infernalReactorVentId).func_77655_b("infernalReactorVent");
        quartzCondensator = new ItemReactorCondensator(Config.quartzCondensatorId, 50000).func_77655_b("quartzCondensator").func_77625_d(1);
        infernalPlate = new ItemAR(Config.infernalPlateId).func_77655_b("plateInfernal");
        dustObsidian = new ItemAR(Config.dustObsidianId).func_77655_b("dustObsidian");
        OreDictionary.registerOre((String)"dustObsidian", (ItemStack)new ItemStack(dustObsidian));
        obsidianPlate = new ItemAR(Config.obsidianPlateId).func_77655_b("plateDenseObsidian");
        obsidianNeutronReflector = new ItemReactorReflector(Config.obsidianNeutronReflectorId, 50000).func_77655_b("obsidianNeutronReflector");
        thickObsidianNeutronReflector = new ItemReactorReflector(Config.thickObsidianNeutronReflectorId, 200000).func_77655_b("thickObsidianNeutronReflector");
        weepingCoolantCell = new ItemWeepingCoolantCell(Config.weepingCoolantCellId);
        plateDenseLead = new ItemAR(Config.plateDenseLeadId).func_77655_b("plateDenseLead");
        OreDictionary.registerOre((String)"plateDenseLead", (Item)plateDenseLead);
        ingotInfernal = new ItemAR(Config.ingotInfernalId).func_77655_b("ingotInfernal");
        OreDictionary.registerOre((String)"ingotInfernal", (Item)ingotInfernal);
    }

    public static void initRecipes() {
        boolean hasGregtech = Loader.isModLoaded((String)"GregTech_Addon") || Loader.isModLoaded((String)"gregtech_addon");
        int numReactors = ReactorType.values().length;
        int numChambers = ReactorChamberType.values().length;
        ItemStack[] reactor = new ItemStack[numReactors];
        ItemStack[] chamber = new ItemStack[numChambers];
        for (ReactorType reactorType : ReactorType.values()) {
            reactor[reactorType.ordinal()] = new ItemStack(blockReactor, 1, reactorType.ordinal());
        }
        for (Enum enum_ : ReactorChamberType.values()) {
            chamber[enum_.ordinal()] = new ItemStack(blockReactorChamber, 1, enum_.ordinal());
        }
        if (Config.disableClassicReactors) {
            ModItems.removeRecipe(Items.getItem("reactorChamber"));
            ModItems.removeRecipe(Items.getItem("nuclearReactor"));
            ItemStack rtGenerator = Items.getItem("RTGenerator");
            if (rtGenerator != null) {
                ModItems.removeRecipe(rtGenerator);
                Recipes.advRecipes.addRecipe(rtGenerator, "III", "ICI", "IGI", Character.valueOf('I'), Items.getItem("casingiron"), Character.valueOf('C'), chamber[0], Character.valueOf('G'), Items.getItem("generator"));
            }
        }
        ItemStack reactorChamberPlate = Items.getItem("denseplatecopper");
        if (Config.reactorChambersUseLeadPlates) {
            AdvancedReactors.logger.info("Switching reactor chambers to use Lead plates instead of Copper plates");
            reactorChamberPlate = Items.getItem("denseplatelead");
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockHighTempMachine, 1), (Object[])new Object[]{"qqq", "qmq", "qqq", Character.valueOf('m'), Items.getItem("machine"), Character.valueOf('q'), Item.field_94583_ca});
        GameRegistry.addRecipe((ItemStack)chamber[0], (Object[])new Object[]{" d ", "dmd", " d ", Character.valueOf('d'), reactorChamberPlate, Character.valueOf('m'), blockHighTempMachine});
        GameRegistry.addRecipe((ItemStack)chamber[1], (Object[])new Object[]{" h ", "hch", " h ", Character.valueOf('h'), Items.getItem("reactorPlatingHeat"), Character.valueOf('c'), chamber[0]});
        GameRegistry.addRecipe((ItemStack)chamber[1], (Object[])new Object[]{"hdh", "dmd", "hdh", Character.valueOf('h'), Items.getItem("reactorPlatingHeat"), Character.valueOf('d'), reactorChamberPlate, Character.valueOf('m'), blockHighTempMachine});
        GameRegistry.addRecipe((ItemStack)chamber[2], (Object[])new Object[]{" h ", "hch", " h ", Character.valueOf('h'), Items.getItem("reactorPlatingExplosive"), Character.valueOf('c'), chamber[0]});
        GameRegistry.addRecipe((ItemStack)chamber[2], (Object[])new Object[]{"hdh", "dmd", "hdh", Character.valueOf('h'), Items.getItem("reactorPlatingExplosive"), Character.valueOf('d'), reactorChamberPlate, Character.valueOf('m'), blockHighTempMachine});
        GameRegistry.addRecipe((ItemStack)chamber[3], (Object[])new Object[]{"pbp", "bcb", "pbp", Character.valueOf('c'), chamber[1], Character.valueOf('p'), infernalPlate, Character.valueOf('b'), Block.field_72033_bA});
        GameRegistry.addRecipe((ItemStack)chamber[4], (Object[])new Object[]{"eae", "xhx", "ewe", Character.valueOf('e'), Item.field_77748_bA, Character.valueOf('a'), Items.getItem("advancedCircuit"), Character.valueOf('x'), Items.getItem("reactorHeatSwitchDiamond"), Character.valueOf('h'), chamber[0], Character.valueOf('w'), Block.field_72082_bJ});
        GameRegistry.addRecipe((ItemStack)reactor[0], (Object[])new Object[]{" a ", "cgc", " l ", Character.valueOf('a'), Items.getItem("advancedCircuit"), Character.valueOf('c'), chamber[0], Character.valueOf('g'), Items.getItem("generator"), Character.valueOf('l'), Items.getItem("denseplatelapi")});
        GameRegistry.addRecipe((ItemStack)reactor[1], (Object[])new Object[]{" l ", "brh", " c ", Character.valueOf('b'), Items.getItem("reactorPlatingExplosive"), Character.valueOf('h'), Items.getItem("reactorPlatingHeat"), Character.valueOf('c'), chamber[0], Character.valueOf('r'), reactor[0], Character.valueOf('l'), Items.getItem("denseplatelapi")});
        GameRegistry.addRecipe((ItemStack)reactor[1], (Object[])new Object[]{" l ", "hrb", " c ", Character.valueOf('b'), Items.getItem("reactorPlatingExplosive"), Character.valueOf('h'), Items.getItem("reactorPlatingHeat"), Character.valueOf('c'), chamber[0], Character.valueOf('r'), reactor[0], Character.valueOf('l'), Items.getItem("denseplatelapi")});
        GameRegistry.addRecipe((ItemStack)reactor[2], (Object[])new Object[]{"lal", "crh", "lal", Character.valueOf('a'), Items.getItem("advancedCircuit"), Character.valueOf('h'), chamber[1], Character.valueOf('c'), chamber[2], Character.valueOf('r'), reactor[1], Character.valueOf('l'), Items.getItem("denseplatelapi")});
        GameRegistry.addRecipe((ItemStack)reactor[2], (Object[])new Object[]{"lal", "hrc", "lal", Character.valueOf('a'), Items.getItem("advancedCircuit"), Character.valueOf('h'), chamber[1], Character.valueOf('c'), chamber[2], Character.valueOf('r'), reactor[1], Character.valueOf('l'), Items.getItem("denseplatelapi")});
        if (!hasGregtech && Config.reactorChambersUseLeadPlates) {
            if (Config.cheapLeadPlateRecipe) {
                Recipes.compressor.addRecipe(new RecipeInputOreDict("ingotLead", 4), null, reactorChamberPlate);
            } else {
                Recipes.compressor.addRecipe(new RecipeInputOreDict("ingotLead", 8), null, reactorChamberPlate);
            }
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(infernalReactorVent, 1), (Object[])new Object[]{" b ", "bvb", " b ", Character.valueOf('b'), Item.field_94584_bZ, Character.valueOf('v'), Items.getItem("reactorVent")});
        GameRegistry.addRecipe((ItemStack)new ItemStack(quartzCondensator, 1), (Object[])new Object[]{"qqq", "qvq", "qxq", Character.valueOf('q'), Item.field_94583_ca, Character.valueOf('v'), Items.getItem("reactorCondensator"), Character.valueOf('x'), Items.getItem("reactorHeatSwitch")});
        new RechargeRecipe((ItemHeatAbsorber)quartzCondensator, new ItemStack(Item.field_77767_aC, 1), 4000);
        new RechargeRecipe((ItemHeatAbsorber)quartzCondensator, new ItemStack(Item.field_94583_ca, 1), 20000);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(obsidianNeutronReflector, 1), new Object[]{"oco", "cpc", "oco", Character.valueOf('o'), "dustObsidian", Character.valueOf('c'), Items.getItem("coalDust"), Character.valueOf('p'), Items.getItem("denseplateobsidian")}));
        if (hasGregtech) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(thickObsidianNeutronReflector, 1), new Object[]{" r ", "rpr", " r ", Character.valueOf('r'), obsidianNeutronReflector, Character.valueOf('p'), "molecule_1be"}));
        } else {
            GameRegistry.addRecipe((ItemStack)new ItemStack(thickObsidianNeutronReflector, 1), (Object[])new Object[]{"prp", "rpr", "prp", Character.valueOf('r'), obsidianNeutronReflector, Character.valueOf('p'), Items.getItem("platecopper")});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(weepingCoolantCell, 1), (Object[])new Object[]{Items.getItem("cell"), Item.field_77732_bp, Item.field_77732_bp});
        if (Config.infernalPlatesUseCopperPlates) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(infernalPlate, 1), (Object[])new Object[]{" b ", "bdb", " b ", Character.valueOf('d'), Items.getItem("denseplatecopper"), Character.valueOf('b'), Item.field_94584_bZ});
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ingotInfernal, 2), new Object[]{"rrr", "nnn", "bbb", Character.valueOf('r'), Items.getItem("plateiron"), Character.valueOf('n'), Item.field_94584_bZ, Character.valueOf('b'), Items.getItem("platebronze")}));
            Recipes.compressor.addRecipe(new RecipeInputItemStack(new ItemStack(ingotInfernal), 1), null, new ItemStack(infernalPlate, 1));
        }
        GameRegistry.addShapelessRecipe((ItemStack)Items.getItem("denseplatelapi"), (Object[])new Object[]{new ItemStack(lapisPlate)});
        GameRegistry.addShapelessRecipe((ItemStack)Items.getItem("denseplateobsidian"), (Object[])new Object[]{new ItemStack(obsidianPlate)});
        GameRegistry.addShapelessRecipe((ItemStack)Items.getItem("denseplatelead"), (Object[])new Object[]{new ItemStack(plateDenseLead)});
    }

    private static boolean removeRecipe(ItemStack product) {
        if (product == null) {
            return false;
        }
        boolean success = false;
        List tList = CraftingManager.func_77594_a().func_77592_b();
        Iterator iter = tList.iterator();
        while (iter.hasNext()) {
            ItemStack stack = ((IRecipe)iter.next()).func_77571_b();
            if (stack == null || !stack.func_77969_a(product)) continue;
            iter.remove();
            success = true;
        }
        return success;
    }
}

