/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.blocks;

public enum ReactorChamberType {
    BASIC("reactorChamberBasic", 0, 0.0f),
    HEATCAPACITY("reactorChamberHeat", 6000, -0.05f),
    CONTAINMENT("reactorChamberContainment", -1000, 0.3f),
    INFERNAL("reactorChamberInfernal", 8000, 0.35f),
    ENDER("reactorChamberEnder", -1000, -0.05f);

    public String blockName;
    public short heatbonus;
    public float blastResistBonus;

    private ReactorChamberType(String blockName, int heatBonus, float blastResistBonus) {
        this.blockName = blockName;
        this.heatbonus = (short)heatBonus;
        this.blastResistBonus = blastResistBonus;
    }

    public static short getHeatBonusForMeta(int meta) {
        if (meta < 0 || meta >= ReactorChamberType.values().length) {
            return 0;
        }
        return ReactorChamberType.values()[meta].heatbonus;
    }

    public static float getBlastResistBonusForMeta(int meta) {
        if (meta < 0 || meta >= ReactorChamberType.values().length) {
            return 0.0f;
        }
        return ReactorChamberType.values()[meta].blastResistBonus;
    }

    public static String getNameForMeta(int meta) {
        if (meta < 0 || meta >= ReactorChamberType.values().length) {
            return "";
        }
        return ReactorChamberType.values()[meta].blockName;
    }
}

