/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.items;

import ic2.api.reactor.IReactor;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import phero.mods.advancedreactors.AdvancedReactors;
import phero.mods.advancedreactors.items.ItemHeatAbsorber;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactor;

public class ItemInfernalReactorVent
extends ItemHeatAbsorber {
    public int selfVent = 16;
    private int fireVent = 10;
    private int blazeVent = 40;
    Random rand = new Random();

    public ItemInfernalReactorVent(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77637_a(AdvancedReactors.tabAR);
        this.func_77655_b("infernalReactorVent");
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack myStack, int x, int y) {
        boolean spawnFire;
        int heatLevel = this.getHeatForStack(myStack);
        if (heatLevel > 0) {
            this.alterHeat(reactor, myStack, x, y, -this.selfVent);
        }
        boolean bl = spawnFire = this.rand.nextInt(this.maxHeatStorage) < heatLevel;
        if (!spawnFire) {
            return;
        }
        TileEntityNuclearReactor nuke = (TileEntityNuclearReactor)reactor;
        ChunkCoordinates coord = nuke.getRandomCoordInHeatEffectRange();
        World world = nuke.field_70331_k;
        if (coord != null && coord.func_82371_e(nuke.getPosition()) > 1.0f) {
            boolean spawnBlaze;
            int spawnX = coord.field_71574_a;
            int spawnY = coord.field_71572_b;
            int spawnZ = coord.field_71573_c;
            if (!nuke.field_70331_k.func_72799_c(spawnX, spawnY, spawnZ)) {
                return;
            }
            boolean bl2 = spawnBlaze = this.rand.nextInt(10000) == 1;
            if (spawnBlaze) {
                EntityBlaze spawn = new EntityBlaze(world);
                spawn.func_70107_b((double)spawnX, (double)spawnY, (double)spawnZ);
                if (world.func_72838_d((Entity)spawn)) {
                    this.alterHeat(reactor, myStack, x, y, -this.blazeVent);
                }
            } else if (nuke.spawnFireAt(spawnX, spawnY, spawnZ)) {
                this.alterHeat(reactor, myStack, x, y, -this.fireVent);
            }
        }
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY) {
        return false;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 0.0f;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean debug) {
    }
}

