/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.LiquidFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.Util;

public class LiquidSlot
implements Slot {
    private int x;
    private int y;
    private int width = 16;
    private int height = 16;
    private SlotType slotType = SlotType.INPUT_SLOT;
    private static NamedTexture containerTexture = null;

    public LiquidSlot(int x, int y) {
        this.x = x;
        this.y = y;
        if (containerTexture == null) {
            containerTexture = Util.instance.getTexture("liquidFilterContainer");
        }
    }

    @Override
    public void draw(Renderer renderer, int recipeX, int recipeY, Object[] data, int dataIndex, boolean isMouseOver) {
        int x = recipeX + this.x;
        int y = recipeY + this.y;
        if (data[dataIndex] instanceof FluidStack) {
            FluidStack liquid = (FluidStack)data[dataIndex];
            TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
            Fluid fluid = liquid.getFluid();
            Icon icon = fluid.getStillIcon();
            if (icon != null) {
                textureManager.func_110577_a(TextureMap.field_110575_b);
                double u = icon.func_94214_a(3.0);
                double u2 = icon.func_94214_a(13.0);
                double v = icon.func_94207_b(1.0);
                double v2 = icon.func_94207_b(15.0);
                GL11.glEnable((int)3553);
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                GL11.glBegin((int)7);
                GL11.glTexCoord2d((double)u, (double)v);
                GL11.glVertex2i((int)(x + 3), (int)(y + 1));
                GL11.glTexCoord2d((double)u, (double)v2);
                GL11.glVertex2i((int)(x + 3), (int)(y + 15));
                GL11.glTexCoord2d((double)u2, (double)v2);
                GL11.glVertex2i((int)(x + 13), (int)(y + 15));
                GL11.glTexCoord2d((double)u2, (double)v);
                GL11.glVertex2i((int)(x + 13), (int)(y + 1));
                GL11.glEnd();
            }
        }
        renderer.renderRect(x - 1, y - 1, 18, 18, containerTexture);
    }

    @Override
    public ItemFilter getClickedFilter(int x, int y, Object[] data, int dataIndex) {
        if (data[dataIndex] instanceof FluidStack) {
            return new LiquidFilter((FluidStack)data[dataIndex]);
        }
        return null;
    }

    @Override
    public boolean isPointInBounds(int x, int y, Object[] data, int dataIndex) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    @Override
    public List<String> getTooltip(int x, int y, Object[] data, int dataIndex) {
        ArrayList<String> tooltip = null;
        if (data[dataIndex] instanceof FluidStack) {
            tooltip = new ArrayList<String>(1);
            FluidStack stack = (FluidStack)data[dataIndex];
            tooltip.add(stack.getFluid().getLocalizedName() + " (" + stack.amount + " milliBuckets)");
        }
        return tooltip;
    }

    @Override
    public boolean matches(ItemFilter filter, Object[] data, int dataIndex, SlotType type) {
        if (!(data[dataIndex] instanceof FluidStack) || type != this.slotType && (type != SlotType.ANY_SLOT || this.slotType == SlotType.DISPLAY_SLOT || this.slotType == SlotType.HIDDEN_SLOT)) {
            return false;
        }
        FluidStack stack = (FluidStack)data[dataIndex];
        if (filter.matches(stack)) {
            return true;
        }
        for (FluidContainerRegistry.FluidContainerData liquidData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!stack.isFluidEqual(liquidData.fluid) || !filter.matches(liquidData.filledContainer)) continue;
            return true;
        }
        return false;
    }

    public Slot setSlotType(SlotType type) {
        this.slotType = type;
        return this;
    }
}

