/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.items;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import phero.mods.advancedreactors.items.ItemAR;

public class ItemHeatAbsorber
extends ItemAR
implements IReactorComponent {
    protected int maxHeatStorage;

    public ItemHeatAbsorber(int id) {
        super(id);
        this.maxHeatStorage = 1000;
        this.func_77656_e(10000);
    }

    public ItemHeatAbsorber(int id, int heatStorage) {
        super(id);
        this.maxHeatStorage = heatStorage;
        this.func_77656_e(10000);
    }

    @Override
    public void processChamber(IReactor reactor, ItemStack yourStack, int x, int y) {
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ItemStack yourStack, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY) {
        return false;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ItemStack yourStack) {
        return 0.0f;
    }

    @Override
    public int alterHeat(IReactor reactor, ItemStack yourStack, int x, int y, int heat) {
        int myHeat = this.getHeatForStack(yourStack);
        if ((myHeat += heat) > this.maxHeatStorage) {
            reactor.setItemAt(x, y, null);
            heat = this.maxHeatStorage - myHeat + 1;
        } else {
            if (myHeat < 0) {
                heat = myHeat;
                myHeat = 0;
            } else {
                heat = 0;
            }
            this.setHeatForStack(yourStack, myHeat);
        }
        return heat;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return true;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return this.maxHeatStorage;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ItemStack yourStack, int x, int y) {
        return this.getHeatForStack(yourStack);
    }

    public void setDamageForStack(ItemStack stack, int dmg) {
        stack.func_77964_b(dmg);
    }

    public int getDamageOfStack(ItemStack stack) {
        return stack.func_77960_j();
    }

    public int getMaxDamageEx() {
        return this.func_77612_l();
    }

    protected void setHeatForStack(ItemStack stack, int heat) {
        NBTTagCompound nbtData = stack.func_77978_p();
        if (nbtData == null) {
            nbtData = new NBTTagCompound("tag");
            stack.func_77982_d(nbtData);
        }
        nbtData.func_74768_a("heat", heat);
        if (this.maxHeatStorage > 0) {
            double p = (double)heat / (double)this.maxHeatStorage;
            int newDmg = (int)((double)stack.func_77958_k() * p);
            if (newDmg >= stack.func_77958_k()) {
                newDmg = stack.func_77958_k() - 1;
            }
            stack.func_77964_b(newDmg);
        }
    }

    protected int getHeatForStack(ItemStack stack) {
        NBTTagCompound nbtData = stack.func_77978_p();
        if (nbtData == null) {
            return 0;
        }
        return nbtData.func_74762_e("heat");
    }
}

