/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.util;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.net.URL;
import phero.mods.advancedreactors.AdvancedReactors;

public class LocalizationHandler {
    public static final String LANG_RESOURCE_LOCATION = "assets/advancedreactors/lang/";
    public static String[] LOCALE_FILES = new String[]{"cs_CZ.xml", "cy_GB.xml", "da_DK.xml", "de_DE.xml", "en_US.xml", "es_ES.xml", "fi_FI.xml", "fr_FR.xml", "it_IT.xml", "ja_JP.xml", "la_IT.xml", "nl_NL.xml", "nb_NO.xml", "pl_PL.xml", "pt_BR.xml", "pt_PT.xml", "ru_RU.xml", "sk_SK.xml", "sr_RS.xml", "sv_SE.xml", "tr_TR.xml", "zh_CN.xml", "zh_TW.xml", "el_GR.xml"};

    public static void loadLanguages() {
        String[] localeFiles = null;
        try {
            URL langFolder = LocalizationHandler.class.getClassLoader().getResource(LANG_RESOURCE_LOCATION);
            localeFiles = new File(langFolder.toURI()).list();
            if (localeFiles != null && localeFiles.length > 0) {
                AdvancedReactors.logger.info("Loading automatic lang list from assets/advancedreactors/lang/ (add your extra lang.xml files here)");
            }
        }
        catch (Exception e) {
            localeFiles = null;
        }
        if (localeFiles == null || localeFiles.length == 0) {
            localeFiles = LOCALE_FILES;
            AdvancedReactors.logger.info("Automatic lang list loading failed - reverting to static list");
        }
        for (String localizationFile : localeFiles) {
            if (localizationFile.startsWith(".")) continue;
            String localizationPath = LANG_RESOURCE_LOCATION + localizationFile;
            URL localizationURL = LocalizationHandler.class.getResource("/" + localizationPath);
            if (localizationURL == null) continue;
            String localeString = LocalizationHandler.getLocaleFromFileName(localizationPath);
            LanguageRegistry.instance().loadLocalization(localizationURL, localeString, LocalizationHandler.isXMLLanguageFile(localizationPath));
        }
    }

    private static boolean isXMLLanguageFile(String fileName) {
        return fileName.endsWith(".xml");
    }

    private static String getLocaleFromFileName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(47) + 1, fileName.lastIndexOf(46));
    }
}

