/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import phero.mods.advancedreactors.AdvancedReactors;
import phero.mods.advancedreactors.blocks.BlockReactor;
import phero.mods.advancedreactors.blocks.ReactorChamberType;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactor;
import phero.mods.advancedreactors.tileentity.TileEntityReactorChamberElectric;
import phero.mods.advancedreactors.tileentity.TileEntityReactorChamberSteam;
import phero.mods.advancedreactors.util.Config;
import phero.mods.advancedreactors.util.ModItems;

public class BlockReactorChamber
extends BlockContainer {
    private Icon[][] icons;

    public BlockReactorChamber(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(2.0f);
        this.func_71894_b(5.0f);
        this.func_71884_a(field_71977_i);
        this.func_71864_b("blockReactorChamber");
        this.func_71849_a(AdvancedReactors.tabAR);
        this.func_71907_b(true);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int meta) {
        if (AdvancedReactors.enableSteamReactor) {
            return new TileEntityReactorChamberSteam();
        }
        return new TileEntityReactorChamberElectric();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.icons = new Icon[ReactorChamberType.values().length][2];
        for (ReactorChamberType chamber : ReactorChamberType.values()) {
            int meta = chamber.ordinal();
            this.icons[meta][0] = par1IconRegister.func_94245_a(String.format("advancedreactors:reactorchamber%d_topbottom", meta + 1));
            this.icons[meta][1] = par1IconRegister.func_94245_a(String.format("advancedreactors:reactorchamber%d_side", meta + 1));
        }
    }

    public int getMetadata(int i) {
        return i;
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return Config.highTempMachineBlockId;
    }

    public int func_71899_b(int meta) {
        return 0;
    }

    public Icon func_71858_a(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.icons[meta][0];
        }
        return this.icons[meta][1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random random) {
        ChunkCoordinates reactorLoc = this.findReactor(world, x, y, z);
        if (reactorLoc == null) {
            return;
        }
        TileEntity reactor = world.func_72796_p(reactorLoc.field_71574_a, reactorLoc.field_71572_b, reactorLoc.field_71573_c);
        if (!(reactor instanceof TileEntityNuclearReactor)) {
            super.func_71862_a(world, x, y, z, random);
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 3: {
                if (random.nextInt(100) >= 1) break;
                double d5 = (float)x + random.nextFloat();
                double d7 = (double)y + this.field_72022_cl;
                double d6 = (float)z + random.nextFloat();
                world.func_72869_a("lava", d5, d7, d6, 0.0, 0.0, 0.0);
                world.func_72980_b(d5, d7, d6, "liquid.lavapop", 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                break;
            }
            case 4: {
                int i1 = random.nextInt(2) * 2 - 1;
                int j1 = random.nextInt(2) * 2 - 1;
                double px = (double)x + 0.5 + 0.125 * (double)i1;
                double py = (float)y + random.nextFloat();
                double pz = (double)z + 0.5 + 0.125 * (double)j1;
                double vx = random.nextFloat() * (float)i1;
                double vy = ((double)random.nextFloat() - 0.5) * 0.125;
                double vz = random.nextFloat() * (float)j1;
                world.func_72869_a("portal", px, py, pz, vx, vy, vz);
            }
        }
        int flames = (int)(4.0f * ((TileEntityNuclearReactor)reactor).getHeatRatio());
        if (flames > 0) {
            int i;
            flames = random.nextInt(flames);
            for (i = 0; i < flames; ++i) {
                world.func_72869_a("smoke", (double)((float)x + random.nextFloat()), (double)y + 0.95, (double)((float)z + random.nextFloat()), 0.0, 0.0, 0.0);
            }
            flames = (int)Math.sqrt(flames);
            for (i = 0; i < flames; ++i) {
                world.func_72869_a("flame", (double)((float)x + random.nextFloat()), (double)y + 0.95, (double)((float)z + random.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        int count = 0;
        if (this.isReactorAt(world, x + 1, y, z)) {
            ++count;
        }
        if (this.isReactorAt(world, x - 1, y, z)) {
            ++count;
        }
        if (this.isReactorAt(world, x, y + 1, z)) {
            ++count;
        }
        if (this.isReactorAt(world, x, y - 1, z)) {
            ++count;
        }
        if (this.isReactorAt(world, x, y, z + 1)) {
            ++count;
        }
        if (this.isReactorAt(world, x, y, z - 1)) {
            ++count;
        }
        return count == 1;
    }

    public boolean isReactorAt(World world, int x, int y, int z) {
        TileEntity target = world.func_72796_p(x, y, z);
        return target != null && target instanceof TileEntityNuclearReactor && world.func_72798_a(x, y, z) == ModItems.blockReactor.field_71990_ca;
    }

    private ChunkCoordinates findReactor(World world, int x, int y, int z) {
        if (this.isReactorAt(world, x + 1, y, z)) {
            return new ChunkCoordinates(x + 1, y, z);
        }
        if (this.isReactorAt(world, x - 1, y, z)) {
            return new ChunkCoordinates(x - 1, y, z);
        }
        if (this.isReactorAt(world, x, y + 1, z)) {
            return new ChunkCoordinates(x, y + 1, z);
        }
        if (this.isReactorAt(world, x, y - 1, z)) {
            return new ChunkCoordinates(x, y - 1, z);
        }
        if (this.isReactorAt(world, x, y, z + 1)) {
            return new ChunkCoordinates(x, y, z + 1);
        }
        if (this.isReactorAt(world, x, y, z - 1)) {
            return new ChunkCoordinates(x, y, z - 1);
        }
        return null;
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float playerX, float playerY, float playerZ) {
        BlockReactor reactor = (BlockReactor)ModItems.blockReactor;
        ChunkCoordinates coords = this.findReactor(world, x, y, z);
        return coords != null && reactor.func_71903_a(world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, player, side, playerX, playerY, playerZ);
    }

    public void func_71863_a(World world, int x, int y, int z, int l) {
        if (!this.func_71930_b(world, x, y, z)) {
            int meta = world.func_72805_g(x, y, z);
            this.func_71929_a(world, x, y, z, new ItemStack(world.func_72798_a(x, y, z), 1, meta));
            world.func_72832_d(x, y, z, 0, 0, 7);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int j, CreativeTabs tabs, List itemList) {
        for (ReactorChamberType chamber : ReactorChamberType.values()) {
            itemList.add(new ItemStack((Block)this, 1, chamber.ordinal()));
        }
    }
}

