/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.Items;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import phero.mods.advancedreactors.AdvancedReactors;
import phero.mods.advancedreactors.blocks.ReactorType;
import phero.mods.advancedreactors.tileentity.TileEntityGenerator;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactor;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactorElectric;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactorSteam;
import phero.mods.advancedreactors.util.Config;

public class BlockReactor
extends BlockContainer {
    private Icon[][] icons;

    public BlockReactor(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(3.0f);
        this.func_71894_b(5.0f);
        this.func_71884_a(field_71977_i);
        this.func_71864_b("blockReactor");
        this.func_71849_a(AdvancedReactors.tabAR);
        this.func_71907_b(true);
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int meta) {
        TileEntityNuclearReactor reactor = null;
        reactor = AdvancedReactors.enableSteamReactor ? new TileEntityNuclearReactorSteam() : new TileEntityNuclearReactorElectric();
        return reactor;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.icons = new Icon[ReactorType.values().length][4];
        for (ReactorType reactor : ReactorType.values()) {
            int meta = reactor.ordinal();
            this.icons[meta][0] = par1IconRegister.func_94245_a(String.format("advancedreactors:reactor%d_bottom", meta + 1));
            this.icons[meta][1] = par1IconRegister.func_94245_a(String.format("advancedreactors:reactor%d_top", meta + 1));
            this.icons[meta][2] = par1IconRegister.func_94245_a(String.format("advancedreactors:reactor%d_side_off", meta + 1));
            this.icons[meta][3] = par1IconRegister.func_94245_a(String.format("advancedreactors:reactor%d_side_on", meta + 1));
        }
    }

    public int getMetadata(int i) {
        return i;
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return Items.getItem((String)"generator").field_77993_c;
    }

    public int func_71899_b(int meta) {
        return 0;
    }

    public Icon func_71895_b(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        boolean active;
        int meta = iBlockAccess.func_72805_g(x, y, z);
        if (side == 0 || side == 1) {
            return this.icons[meta][side];
        }
        TileEntity reactor = iBlockAccess.func_72796_p(x, y, z);
        boolean bl = active = reactor != null && ((TileEntityGenerator)reactor).isActive();
        if (active) {
            return this.icons[meta][3];
        }
        return this.icons[meta][2];
    }

    public Icon func_71858_a(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.icons[meta][side];
        }
        return this.icons[meta][2];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random random) {
        TileEntity reactor = world.func_72796_p(x, y, z);
        if (!(reactor instanceof TileEntityNuclearReactor)) {
            super.func_71862_a(world, x, y, z, random);
            return;
        }
        int flames = (int)(4.0f * ((TileEntityNuclearReactor)reactor).getHeatRatio());
        if (flames > 0) {
            int i;
            flames = random.nextInt(flames);
            for (i = 0; i < flames; ++i) {
                world.func_72869_a("smoke", (double)((float)x + random.nextFloat()), (double)y + 0.95, (double)((float)z + random.nextFloat()), 0.0, 0.0, 0.0);
            }
            flames = (int)Math.sqrt(flames);
            for (i = 0; i < flames; ++i) {
                world.func_72869_a("flame", (double)((float)x + random.nextFloat()), (double)y + 0.95, (double)((float)z + random.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
    }

    private void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        float scatter = 0.8f;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = (rand.nextFloat() - 0.5f) * scatter + 0.5f;
            float ry = (rand.nextFloat() - 0.5f) * scatter + 0.5f;
            float rz = (rand.nextFloat() - 0.5f) * scatter + 0.5f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.field_77993_c, item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        this.dropItems(world, x, y, z);
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float playerX, float playerY, float playerZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().field_77993_c == Config.reactorChamberId) {
            return false;
        }
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileEntityNuclearReactor) {
            player.openGui((Object)AdvancedReactors.instance, 0, world, x, y, z);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int j, CreativeTabs tabs, List itemList) {
        for (ReactorType reactor : ReactorType.values()) {
            itemList.add(new ItemStack((Block)this, 1, reactor.ordinal()));
        }
    }
}

